/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BdaBitString;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.ObjectReference;

public final class BdaReasonForInclusion
extends BdaBitString {
    public BdaReasonForInclusion(ObjectReference objectReference) {
        super(objectReference, null, null, 7, false, false);
        this.basicType = BdaType.REASON_FOR_INCLUSION;
        this.setDefault();
    }

    @Override
    public BdaReasonForInclusion copy() {
        BdaReasonForInclusion copy = new BdaReasonForInclusion(this.objectReference);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public boolean isDataChange() {
        return (this.value[0] & 0x40) == 64;
    }

    public void setDataChange(boolean dataChange) {
        this.value[0] = dataChange ? (byte)(this.value[0] | 0x40) : (byte)(this.value[0] & 0xBF);
    }

    public boolean isQualityChange() {
        return (this.value[0] & 0x20) == 32;
    }

    public void setQualityChange(boolean qualityChange) {
        this.value[0] = qualityChange ? (byte)(this.value[0] | 0x20) : (byte)(this.value[0] & 0xDF);
    }

    public boolean isDataUpdate() {
        return (this.value[0] & 0x10) == 16;
    }

    public void setDataUpdate(boolean dataUpdate) {
        this.value[0] = dataUpdate ? (byte)(this.value[0] | 0x10) : (byte)(this.value[0] & 0xEF);
    }

    public boolean isIntegrity() {
        return (this.value[0] & 8) == 8;
    }

    public void setIntegrity(boolean integrity) {
        this.value[0] = integrity ? (byte)(this.value[0] | 8) : (byte)(this.value[0] & 0xF7);
    }

    public boolean isGeneralInterrogation() {
        return (this.value[0] & 4) == 4;
    }

    public void setGeneralInterrogation(boolean generalInterrogation) {
        this.value[0] = generalInterrogation ? (byte)(this.value[0] | 4) : (byte)(this.value[0] & 0xFB);
    }

    public boolean isApplicationTrigger() {
        return (this.value[0] & 2) == 2;
    }

    public void setApplicationTrigger(boolean applicationTrigger) {
        this.value[0] = applicationTrigger ? (byte)(this.value[0] | 2) : (byte)(this.value[0] & 0xFD);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.isDataChange()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("data-change");
        }
        if (this.isDataUpdate()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("data-update");
        }
        if (this.isQualityChange()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("quality-change");
        }
        if (this.isIntegrity()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("integrity");
        }
        if (this.isGeneralInterrogation()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("general-interrogation");
        }
        if (this.isApplicationTrigger()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append("application-trigger");
        }
        return sb.toString();
    }
}

