/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.BerInteger;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned8;

public final class BdaInt16
extends BasicDataAttribute {
    private volatile short value;

    public BdaInt16(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.INT16;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        this.value = ((BdaInt16)bda).getValue();
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public void setDefault() {
        this.value = 0;
    }

    @Override
    public BdaInt16 copy() {
        BdaInt16 copy = new BdaInt16(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        copy.setValue(this.value);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setInteger(new BerInteger((long)this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getInteger() == null) {
            throw new ServiceError(10, "expected type: integer");
        }
        this.value = data.getInteger().value.shortValue();
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setInteger(new Unsigned8(16L));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.value;
    }
}

