/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.BerInteger;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned8;

public final class BdaInt128
extends BasicDataAttribute {
    private volatile long value;

    public BdaInt128(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.INT128;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        this.value = ((BdaInt128)bda).getValue();
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void setDefault() {
        this.value = 0L;
    }

    @Override
    public BdaInt128 copy() {
        BdaInt128 copy = new BdaInt128(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        copy.setValue(this.value);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setInteger(new BerInteger(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getInteger() == null) {
            throw new ServiceError(10, "expected type: integer");
        }
        this.value = data.getInteger().value.longValue();
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setInteger(new Unsigned8(128L));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.value;
    }

    @Override
    public String getValueString() {
        return "" + this.value;
    }
}

