/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.FloatingPoint;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned8;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class BdaFloat64
extends BasicDataAttribute {
    private volatile byte[] value = new byte[]{11, 0, 0, 0, 0, 0, 0, 0, 0};

    public BdaFloat64(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.FLOAT64;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaFloat64)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value != null && value.length != 9) {
            throw new IllegalArgumentException("value does not have length 9");
        }
        this.value = value;
    }

    public Double getDouble() {
        if (this.value == null) {
            return null;
        }
        return Double.longBitsToDouble((0xFFL & (long)this.value[1]) << 56 | (0xFFL & (long)this.value[2]) << 48 | (0xFFL & (long)this.value[3]) << 40 | (0xFFL & (long)this.value[4]) << 32 | (0xFFL & (long)this.value[5]) << 24 | (0xFFL & (long)this.value[6]) << 16 | (0xFFL & (long)this.value[7]) << 8 | (0xFFL & (long)this.value[8]) << 0);
    }

    public void setDouble(Double value) {
        this.value = ByteBuffer.allocate(9).put((byte)11).putDouble(value).array();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{11, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    @Override
    public BdaFloat64 copy() {
        BdaFloat64 copy = new BdaFloat64(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        if (this.value == null) {
            return null;
        }
        Data data = new Data();
        data.setFloatingPoint(new FloatingPoint(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getFloatingPoint() == null || data.getFloatingPoint().value.length != 9) {
            throw new ServiceError(10, "expected type: floating_point as an octet string of size 9");
        }
        this.value = data.getFloatingPoint().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription.FloatingPoint floatingPointTypeDescription = new TypeDescription.FloatingPoint();
        floatingPointTypeDescription.setFormatWidth(new Unsigned8(64L));
        floatingPointTypeDescription.setExponentWidth(new Unsigned8(11L));
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setFloatingPoint(floatingPointTypeDescription);
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.getDouble();
    }

    @Override
    public String getValueString() {
        return "" + Arrays.toString(this.value);
    }
}

