/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.aop;

import com.baomidou.lock.LockFailureStrategy;
import com.baomidou.lock.LockInfo;
import com.baomidou.lock.LockKeyBuilder;
import com.baomidou.lock.LockTemplate;
import com.baomidou.lock.annotation.Lock4j;
import com.baomidou.lock.spring.boot.autoconfigure.Lock4jProperties;
import java.lang.reflect.AnnotatedElement;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class LockInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LockInterceptor.class);
    private final LockTemplate lockTemplate;
    private final LockKeyBuilder lockKeyBuilder;
    private final LockFailureStrategy lockFailureStrategy;
    private final Lock4jProperties lock4jProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object var7_8;
        block7: {
            boolean releaseLock;
            String key;
            LockInfo lockInfo;
            Lock4j lock4j;
            block5: {
                Object object;
                block6: {
                    Class cls = AopProxyUtils.ultimateTargetClass((Object)invocation.getThis());
                    if (!cls.equals(invocation.getThis().getClass())) {
                        return invocation.proceed();
                    }
                    lock4j = (Lock4j)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), Lock4j.class);
                    lockInfo = null;
                    try {
                        boolean releaseLock2;
                        String prefix = this.lock4jProperties.getLockKeyPrefix() + ":";
                        prefix = prefix + (StringUtils.hasText((String)lock4j.name()) ? lock4j.name() : invocation.getMethod().getDeclaringClass().getName() + invocation.getMethod().getName());
                        key = prefix + "#" + this.lockKeyBuilder.buildKey(invocation, lock4j.keys());
                        lockInfo = this.lockTemplate.lock(key, lock4j.expire(), lock4j.acquireTimeout(), lock4j.executor());
                        if (null == lockInfo) break block5;
                        object = invocation.proceed();
                        if (null == lockInfo || !lock4j.autoRelease() || (releaseLock2 = this.lockTemplate.releaseLock(lockInfo))) break block6;
                    }
                    catch (Throwable throwable) {
                        boolean releaseLock3;
                        if (null != lockInfo && lock4j.autoRelease() && !(releaseLock3 = this.lockTemplate.releaseLock(lockInfo))) {
                            log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
                        }
                        throw throwable;
                    }
                    log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
                }
                return object;
            }
            this.lockFailureStrategy.onLockFailure(key, invocation.getMethod(), invocation.getArguments());
            var7_8 = null;
            if (null == lockInfo || !lock4j.autoRelease() || (releaseLock = this.lockTemplate.releaseLock(lockInfo))) break block7;
            log.error("releaseLock fail,lockKey={},lockValue={}", (Object)lockInfo.getLockKey(), (Object)lockInfo.getLockValue());
        }
        return var7_8;
    }

    public LockInterceptor(LockTemplate lockTemplate, LockKeyBuilder lockKeyBuilder, LockFailureStrategy lockFailureStrategy, Lock4jProperties lock4jProperties) {
        this.lockTemplate = lockTemplate;
        this.lockKeyBuilder = lockKeyBuilder;
        this.lockFailureStrategy = lockFailureStrategy;
        this.lock4jProperties = lock4jProperties;
    }
}

