/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.implementation.annotation;

import com.azure.spring.messaging.implementation.annotation.AzureListenerConfigurer;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpointRegistrar;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpointRegistry;
import com.azure.spring.messaging.implementation.listener.MessageListenerContainerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public abstract class AzureListenerAnnotationBeanPostProcessorAdapter<T>
implements MergedBeanDefinitionPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureListenerAnnotationBeanPostProcessorAdapter.class);
    public static final String DEFAULT_AZURE_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME = "azureListenerEndpointRegistry";
    protected String containerFactoryBeanName;
    private final MessageHandlerMethodFactoryAdapter messageHandlerMethodFactory = new MessageHandlerMethodFactoryAdapter();
    protected final AtomicInteger counter = new AtomicInteger();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final AzureListenerEndpointRegistrar registrar = new AzureListenerEndpointRegistrar();
    @Nullable
    private AzureListenerEndpointRegistry endpointRegistry;
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
        this.registrar.setBeanFactory(beanFactory);
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.nonAnnotatedClasses.clear();
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map beans = ((ListableBeanFactory)this.beanFactory).getBeansOfType(AzureListenerConfigurer.class);
            ArrayList configurers = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (AzureListenerConfigurer configurer : configurers) {
                configurer.configureAzureListeners(this.registrar);
            }
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (AzureListenerEndpointRegistry)this.beanFactory.getBean(DEFAULT_AZURE_LISTENER_ENDPOINT_REGISTRY_BEAN_NAME, AzureListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean || bean instanceof MessageListenerContainerFactory || bean instanceof AzureListenerEndpointRegistry) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass)) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<T> listenerMethods = this.findListenerMethods(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                LOGGER.trace("No @AzureMessageListener annotations found on bean type: {}", (Object)targetClass);
            } else {
                annotatedMethods.forEach((method, listeners) -> listeners.forEach(listener -> this.processAzureListener((T)listener, (Method)method, bean)));
                LOGGER.debug("{} @AzureMessageListener methods processed on bean '{}': {}", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
            }
        }
        return bean;
    }

    private void processAzureListener(T listenerAnnotation, Method mostSpecificMethod, Object bean) {
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)mostSpecificMethod, bean.getClass());
        AzureListenerEndpoint endpoint = this.createAndConfigureMethodListenerEndpoint(listenerAnnotation, bean, invocableMethod, this.beanFactory, this.messageHandlerMethodFactory);
        MessageListenerContainerFactory factory = null;
        String containerFactoryBeanNameResolved = this.resolve(this.getContainerFactoryBeanName(listenerAnnotation));
        if (StringUtils.hasText((String)containerFactoryBeanNameResolved)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (MessageListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanNameResolved, MessageListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register Azure listener endpoint on [" + String.valueOf(mostSpecificMethod) + "], no " + MessageListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanNameResolved + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    protected abstract Set<T> findListenerMethods(Method var1);

    protected abstract AzureListenerEndpoint createAndConfigureMethodListenerEndpoint(T var1, Object var2, Method var3, BeanFactory var4, MessageHandlerMethodFactory var5);

    protected abstract String getEndpointId(T var1);

    protected abstract String getContainerFactoryBeanName(T var1);

    protected abstract Class<T> getListenerType();

    @Nullable
    protected String resolve(String value) {
        return this.embeddedValueResolver != null ? this.embeddedValueResolver.resolveStringValue(value) : value;
    }

    public abstract String getDefaultAzureListenerAnnotationBeanPostProcessorBeanName();

    private class MessageHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        @Nullable
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private MessageHandlerMethodFactoryAdapter() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultAzureHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
            this.messageHandlerMethodFactory = messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultAzureHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            if (AzureListenerAnnotationBeanPostProcessorAdapter.this.beanFactory != null) {
                defaultFactory.setBeanFactory(AzureListenerAnnotationBeanPostProcessorAdapter.this.beanFactory);
            }
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

