/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusProcessorClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusSessionProcessorClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.servicebus.core.ServiceBusProcessorFactory;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.core.properties.ProcessorProperties;
import com.azure.spring.messaging.servicebus.core.properties.ServiceBusContainerProperties;
import com.azure.spring.messaging.servicebus.implementation.properties.merger.ProcessorPropertiesMerger;
import com.azure.spring.messaging.servicebus.implementation.properties.merger.ProcessorPropertiesParentMerger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class DefaultServiceBusNamespaceProcessorFactory
implements ServiceBusProcessorFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceBusNamespaceProcessorFactory.class);
    private final Map<ConsumerIdentifier, ServiceBusProcessorClient> processorMap = new ConcurrentHashMap<ConsumerIdentifier, ServiceBusProcessorClient>();
    private final List<ServiceBusProcessorFactory.Listener> listeners = new ArrayList<ServiceBusProcessorFactory.Listener>();
    private ApplicationContext applicationContext;
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> propertiesSupplier;
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> serviceBusClientBuilderCustomizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>>();
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>>();
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> sessionCustomizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>>();
    private final Map<ConsumerIdentifier, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>>> dedicatedCustomizers = new HashMap<ConsumerIdentifier, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>>>();
    private final Map<ConsumerIdentifier, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>>> dedicatedSessionCustomizers = new HashMap<ConsumerIdentifier, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>>>();
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver = null;
    private TokenCredential defaultCredential = null;

    public DefaultServiceBusNamespaceProcessorFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultServiceBusNamespaceProcessorFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    public void destroy() {
        this.close(this.processorMap, ServiceBusProcessorClient::close);
        this.processorMap.clear();
        this.listeners.clear();
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String queue, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        return this.doCreateProcessor(queue, null, messageListener, errorHandler, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(queue))));
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String queue, ServiceBusContainerProperties containerProperties) {
        ProcessorProperties propertiesSupplied = (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(queue)));
        ProcessorPropertiesMerger propertiesMerger = new ProcessorPropertiesMerger();
        ProcessorProperties processorProperties = propertiesMerger.merge(containerProperties, propertiesSupplied);
        ServiceBusErrorHandler errorHandler = containerProperties.getErrorHandler();
        MessageListener<?> messageListener = containerProperties.getMessageListener();
        Assert.notNull((Object)errorHandler, (String)"An errorHandler must be provided!");
        Assert.notNull(messageListener, (String)"A message listener must be provided!");
        return this.doCreateProcessor(queue, null, messageListener, errorHandler, processorProperties);
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String topic, String subscription, MessageListener<?> messageListener, ServiceBusErrorHandler errorHandler) {
        return this.doCreateProcessor(topic, subscription, messageListener, errorHandler, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(topic, subscription))));
    }

    @Override
    public ServiceBusProcessorClient createProcessor(String topic, String subscription, ServiceBusContainerProperties containerProperties) {
        ProcessorProperties propertiesSupplied = (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(topic, subscription)));
        ProcessorPropertiesMerger propertiesMerger = new ProcessorPropertiesMerger();
        ProcessorProperties processorProperties = propertiesMerger.merge(containerProperties, propertiesSupplied);
        ServiceBusErrorHandler errorHandler = containerProperties.getErrorHandler();
        MessageListener<?> messageListener = containerProperties.getMessageListener();
        Assert.notNull((Object)errorHandler, (String)"An errorHandler must be provided!");
        Assert.notNull(messageListener, (String)"An message listener must be provided!");
        return this.doCreateProcessor(topic, subscription, messageListener, errorHandler, processorProperties);
    }

    private ServiceBusProcessorClient doCreateProcessor(String name, @Nullable String subscription, @NonNull MessageListener<?> messageListener, @NonNull ServiceBusErrorHandler errorHandler, @Nullable ProcessorProperties properties) {
        ConsumerIdentifier key = new ConsumerIdentifier(name, subscription);
        return this.processorMap.computeIfAbsent(key, k -> {
            ServiceBusProcessorClient client;
            ProcessorPropertiesParentMerger propertiesMerger = new ProcessorPropertiesParentMerger();
            ProcessorProperties processorProperties = propertiesMerger.merge(properties, this.namespaceProperties);
            processorProperties.setEntityName(k.getDestination());
            if (!k.hasGroup()) {
                processorProperties.setEntityType(ServiceBusEntityType.QUEUE);
            } else {
                processorProperties.setEntityType(ServiceBusEntityType.TOPIC);
                processorProperties.setSubscriptionName(k.getGroup());
            }
            if (Boolean.TRUE.equals(processorProperties.getSessionEnabled())) {
                ServiceBusSessionProcessorClientBuilderFactory factory = new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)processorProperties, this.serviceBusClientBuilderCustomizers, messageListener, errorHandler);
                factory.setDefaultTokenCredential(this.defaultCredential);
                factory.setTokenCredentialResolver(this.tokenCredentialResolver);
                factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
                factory.setApplicationContext(this.applicationContext);
                ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder = (ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)factory.build();
                this.customizeBuilder(name, subscription, builder);
                client = builder.buildProcessorClient();
            } else {
                ServiceBusProcessorClientBuilderFactory factory = new ServiceBusProcessorClientBuilderFactory((ServiceBusProcessorClientProperties)processorProperties, this.serviceBusClientBuilderCustomizers, messageListener, errorHandler);
                factory.setDefaultTokenCredential(this.defaultCredential);
                factory.setTokenCredentialResolver(this.tokenCredentialResolver);
                factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
                factory.setApplicationContext(this.applicationContext);
                ServiceBusClientBuilder.ServiceBusProcessorClientBuilder builder = (ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)factory.build();
                this.customizeBuilder(name, subscription, builder);
                client = builder.buildProcessorClient();
            }
            this.listeners.forEach(l -> l.processorAdded(this.buildProcessorName((ConsumerIdentifier)k), client));
            return client;
        });
    }

    @Override
    public void addListener(ServiceBusProcessorFactory.Listener listener) {
        this.listeners.add(listener);
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void setDefaultCredential(TokenCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    private void close(Map<ConsumerIdentifier, ServiceBusProcessorClient> map, Consumer<ServiceBusProcessorClient> close) {
        map.forEach((t, p) -> {
            try {
                this.listeners.forEach(l -> l.processorRemoved(this.buildProcessorName((ConsumerIdentifier)t), (ServiceBusProcessorClient)p));
                close.accept((ServiceBusProcessorClient)p);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to clean service bus queue client factory", (Throwable)ex);
            }
        });
    }

    public void addServiceBusClientBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.class.getName());
        } else {
            this.serviceBusClientBuilderCustomizers.add(customizer);
        }
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusProcessorClientBuilder.class.getName());
        } else {
            this.customizers.add(customizer);
        }
    }

    public void addSessionBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder.class.getName());
        } else {
            this.sessionCustomizers.add(customizer);
        }
    }

    public void addBuilderCustomizer(String entityName, String subscription, AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' dedicated customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusProcessorClientBuilder.class.getName());
        } else {
            this.dedicatedCustomizers.computeIfAbsent(new ConsumerIdentifier(entityName, subscription), key -> new ArrayList()).add(customizer);
        }
    }

    public void addSessionBuilderCustomizer(String entityName, String subscription, AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided '{}' dedicated customizer is null, will ignore it.", (Object)ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder.class.getName());
        } else {
            this.dedicatedSessionCustomizers.computeIfAbsent(new ConsumerIdentifier(entityName, subscription), key -> new ArrayList()).add(customizer);
        }
    }

    private void customizeBuilder(String entityName, String subscription, ServiceBusClientBuilder.ServiceBusProcessorClientBuilder builder) {
        this.customizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedCustomizers.getOrDefault(new ConsumerIdentifier(entityName, subscription), new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }

    private void customizeBuilder(String entityName, String subscription, ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder builder) {
        this.sessionCustomizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedSessionCustomizers.getOrDefault(new ConsumerIdentifier(entityName, subscription), new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }

    private String buildProcessorName(ConsumerIdentifier k) {
        String group = k.getGroup();
        return k.getDestination() + "/" + (group == null ? "" : group);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

