/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.properties.merger;

import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.core.PropertiesMerger;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.core.properties.ProcessorProperties;
import com.azure.spring.messaging.servicebus.implementation.properties.merger.ProcessorPropertiesMerger;

public class ProcessorPropertiesParentMerger
implements PropertiesMerger<ProcessorProperties, NamespaceProperties> {
    public ProcessorProperties merge(ProcessorProperties child, NamespaceProperties parent) {
        ProcessorProperties properties = new ProcessorProperties();
        if (child == null && parent == null) {
            return properties;
        }
        if (child == null) {
            child = new ProcessorProperties();
        }
        if (parent == null) {
            parent = new NamespaceProperties();
        }
        PropertyMapper propertyMapper = new PropertyMapper();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)parent, (AzureProperties)child, (AzureProperties)properties);
        propertyMapper.from((Object)parent.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)parent.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)parent.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)parent.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)parent.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)parent.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        ProcessorPropertiesMerger.copyProcessorPropertiesIfNotNull(child, properties);
        return properties;
    }
}

