/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.checkpoint;

import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointConfig;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointMode;
import com.azure.spring.messaging.eventhubs.implementation.checkpoint.EventCheckpointManager;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class TimeCheckpointManager
extends EventCheckpointManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeCheckpointManager.class);
    private final AtomicReference<LocalDateTime> lastCheckpointTime = new AtomicReference<LocalDateTime>(LocalDateTime.now());

    TimeCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getMode() == CheckpointMode.TIME ? 1 : 0) != 0, () -> "TimeCheckpointManager should have checkpointMode time");
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void checkpoint(EventContext context) {
        LocalDateTime now = LocalDateTime.now();
        if (Duration.between(this.lastCheckpointTime.get(), now).compareTo(this.checkpointConfig.getInterval()) > 0) {
            context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, context.getEventData(), (Throwable)t)).doOnSuccess(v -> {
                this.logCheckpointSuccess(context, context.getEventData());
                this.lastCheckpointTime.set(now);
            }).block();
        }
    }
}

