/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.checkpoint;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointConfig;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointMode;
import com.azure.spring.messaging.eventhubs.implementation.checkpoint.EventCheckpointManager;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class BatchCheckpointManager
extends EventCheckpointManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchCheckpointManager.class);
    private static final String CHECKPOINT_FAIL_MSG = "Consumer group '%s' failed to checkpoint offset %s of message on partition %s in batch mode";
    private static final String CHECKPOINT_SUCCESS_MSG = "Consumer group '%s' succeed to checkpoint offset %s of message on partition %s in batch mode";

    BatchCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((checkpointConfig.getMode() == CheckpointMode.BATCH ? 1 : 0) != 0, () -> "BatchCheckpointManager should have checkpointMode batch");
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    void logCheckpointFail(String consumerGroup, String partitionId, Long offset, Throwable t) {
        this.getLogger().warn(String.format(CHECKPOINT_FAIL_MSG, consumerGroup, offset, partitionId), t);
    }

    void logCheckpointSuccess(String consumerGroup, String partitionId, Long offset) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format(CHECKPOINT_SUCCESS_MSG, consumerGroup, offset, partitionId));
        }
    }

    @Override
    public void checkpoint(EventBatchContext context) {
        EventData lastEvent = this.getLastEventFromBatch(context);
        if (lastEvent == null) {
            return;
        }
        Long offset = lastEvent.getOffset();
        String partitionId = context.getPartitionContext().getPartitionId();
        String consumerGroup = context.getPartitionContext().getConsumerGroup();
        context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(consumerGroup, partitionId, offset, (Throwable)t)).doOnSuccess(v -> this.logCheckpointSuccess(consumerGroup, partitionId, offset)).block();
    }

    private EventData getLastEventFromBatch(EventBatchContext context) {
        List events = context.getEvents();
        if (CollectionUtils.isEmpty((Collection)events)) {
            return null;
        }
        return (EventData)events.get(events.size() - 1);
    }
}

