/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.core;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.InitializationContext;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsErrorHandler;
import com.azure.spring.cloud.service.implementation.eventhubs.factory.EventProcessorClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventProcessorClientProperties;
import com.azure.spring.cloud.service.listener.MessageListener;
import com.azure.spring.messaging.ConsumerIdentifier;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.eventhubs.core.EventHubsProcessorFactory;
import com.azure.spring.messaging.eventhubs.core.properties.EventHubsContainerProperties;
import com.azure.spring.messaging.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.messaging.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.messaging.eventhubs.implementation.properties.merger.ProcessorPropertiesMerger;
import com.azure.spring.messaging.eventhubs.implementation.properties.merger.ProcessorPropertiesParentMerger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class DefaultEventHubsNamespaceProcessorFactory
implements EventHubsProcessorFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventHubsNamespaceProcessorFactory.class);
    private final List<EventHubsProcessorFactory.Listener> listeners = new ArrayList<EventHubsProcessorFactory.Listener>();
    private ApplicationContext applicationContext;
    private final NamespaceProperties namespaceProperties;
    private final CheckpointStore checkpointStore;
    private final PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> propertiesSupplier;
    private final Map<ConsumerIdentifier, EventProcessorClient> processorClientMap = new ConcurrentHashMap<ConsumerIdentifier, EventProcessorClient>();
    private final List<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>>();
    private final Map<String, List<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>>> dedicatedCustomizers = new HashMap<String, List<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>>>();
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver = null;
    private TokenCredential defaultCredential = null;

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore) {
        this(checkpointStore, null, null);
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, NamespaceProperties namespaceProperties) {
        this(checkpointStore, namespaceProperties, (PropertiesSupplier<ConsumerIdentifier, ProcessorProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        this(checkpointStore, null, supplier);
    }

    public DefaultEventHubsNamespaceProcessorFactory(CheckpointStore checkpointStore, NamespaceProperties namespaceProperties, PropertiesSupplier<ConsumerIdentifier, ProcessorProperties> supplier) {
        Assert.notNull((Object)checkpointStore, (String)"CheckpointStore must be provided.");
        this.checkpointStore = checkpointStore;
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public EventProcessorClient createProcessor(@NonNull String eventHub, @NonNull String consumerGroup, @NonNull MessageListener<?> listener, @NonNull EventHubsErrorHandler errorHandler) {
        return this.doCreateProcessor(eventHub, consumerGroup, listener, errorHandler, null, null, (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(eventHub, consumerGroup))));
    }

    @Override
    public EventProcessorClient createProcessor(String eventHub, String consumerGroup, EventHubsContainerProperties containerProperties) {
        ProcessorProperties propertiesSupplied = (ProcessorProperties)((Object)this.propertiesSupplier.getProperties((Object)new ConsumerIdentifier(eventHub, consumerGroup)));
        ProcessorPropertiesMerger propertiesMerger = new ProcessorPropertiesMerger();
        ProcessorProperties processorProperties = propertiesMerger.merge(containerProperties, propertiesSupplied);
        EventHubsErrorHandler errorHandler = containerProperties.getErrorHandler();
        MessageListener<?> messageListener = containerProperties.getMessageListener();
        Assert.notNull((Object)errorHandler, (String)"A error handler must be provided!");
        Assert.notNull(messageListener, (String)"A message listener consumer must be provided!");
        return this.doCreateProcessor(eventHub, consumerGroup, messageListener, errorHandler, containerProperties.getInitializationContextConsumer(), containerProperties.getCloseContextConsumer(), processorProperties);
    }

    public void destroy() {
        this.processorClientMap.forEach((t, client) -> {
            this.listeners.forEach(l -> l.processorRemoved(t.getDestination(), t.getGroup(), (EventProcessorClient)client));
            client.stop();
        });
        this.processorClientMap.clear();
        this.listeners.clear();
    }

    private EventProcessorClient doCreateProcessor(@NonNull String eventHub, @NonNull String consumerGroup, @NonNull MessageListener<?> messageListener, @NonNull EventHubsErrorHandler errorHandler, @Nullable Consumer<InitializationContext> initializationContextConsumer, @Nullable Consumer<CloseContext> closeContextConsumer, @Nullable ProcessorProperties properties) {
        ConsumerIdentifier key = new ConsumerIdentifier(eventHub, consumerGroup);
        return this.processorClientMap.computeIfAbsent(key, k -> {
            ProcessorPropertiesParentMerger propertiesParentMerger = new ProcessorPropertiesParentMerger();
            ProcessorProperties processorProperties = propertiesParentMerger.merge(properties, this.namespaceProperties);
            processorProperties.setEventHubName(k.getDestination());
            processorProperties.setConsumerGroup(k.getGroup());
            EventProcessorClientBuilderFactory factory = new EventProcessorClientBuilderFactory((EventProcessorClientProperties)processorProperties, this.checkpointStore, messageListener, errorHandler);
            factory.setCloseContextConsumer(closeContextConsumer);
            factory.setInitializationContextConsumer(initializationContextConsumer);
            factory.setDefaultTokenCredential(this.defaultCredential);
            factory.setTokenCredentialResolver(this.tokenCredentialResolver);
            factory.setApplicationContext(this.applicationContext);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_EVENT_HUBS);
            EventProcessorClientBuilder builder = (EventProcessorClientBuilder)factory.build();
            this.customizeBuilder(eventHub, consumerGroup, builder);
            EventProcessorClient client = builder.buildEventProcessorClient();
            LOGGER.info("EventProcessor created for event hub '{}' with consumer group '{}'", (Object)k.getDestination(), (Object)k.getGroup());
            this.listeners.forEach(l -> l.processorAdded(k.getDestination(), k.getGroup(), client));
            return client;
        });
    }

    @Override
    public void addListener(EventHubsProcessorFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(EventHubsProcessorFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void setDefaultCredential(TokenCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.customizers.add(customizer);
    }

    public void addBuilderCustomizer(String eventHub, String consumerGroup, AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder> customizer) {
        if (customizer == null) {
            LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.dedicatedCustomizers.computeIfAbsent(this.getCustomizerKey(eventHub, consumerGroup), key -> new ArrayList()).add(customizer);
    }

    private void customizeBuilder(String eventHub, String consumerGroup, EventProcessorClientBuilder builder) {
        this.customizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedCustomizers.getOrDefault(this.getCustomizerKey(eventHub, consumerGroup), new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }

    private String getCustomizerKey(String eventHub, String consumerGroup) {
        return eventHub + "_" + consumerGroup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

