/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.checkpoint;

import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointConfig;
import com.azure.spring.messaging.eventhubs.core.checkpoint.CheckpointMode;
import com.azure.spring.messaging.eventhubs.implementation.checkpoint.EventCheckpointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class RecordCheckpointManager
extends EventCheckpointManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordCheckpointManager.class);

    RecordCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getMode() == CheckpointMode.RECORD ? 1 : 0) != 0, () -> "RecordCheckpointManager should have checkpointMode record");
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void checkpoint(EventContext context) {
        context.updateCheckpointAsync().doOnError(t -> this.logCheckpointFail(context, context.getEventData(), (Throwable)t)).doOnSuccess(v -> this.logCheckpointSuccess(context, context.getEventData())).block();
    }
}

