/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.core.listener.adapter;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.spring.cloud.service.eventhubs.consumer.EventHubsBatchMessageListener;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.eventhubs.implementation.support.converter.EventHubsBatchMessageConverter;
import com.azure.spring.messaging.implementation.listener.adapter.MessagingMessageListenerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class BatchMessagingMessageListenerAdapter
extends MessagingMessageListenerAdapter
implements EventHubsBatchMessageListener {
    public BatchMessagingMessageListenerAdapter() {
        this.messageConverter = new EventHubsBatchMessageConverter();
    }

    public void onMessage(EventBatchContext eventBatchContext) {
        PartitionContext partition = eventBatchContext.getPartitionContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("azure_raw_partition_id", partition.getPartitionId());
        headers.put("azure_eventhubs_last_enqueued_event_properties", (String)eventBatchContext.getLastEnqueuedEventProperties());
        Message message = this.getMessageConverter().toMessage((Object)eventBatchContext, (Map)new MessageHeaders(headers), this.payloadType);
        this.invokeHandler(message);
    }

    public AzureMessageConverter<EventBatchContext, EventData> getMessageConverter() {
        return super.getMessageConverter();
    }
}

