/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.keyvault.secrets;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretClientBuilderFactory
extends AbstractAzureHttpClientBuilderFactory<SecretClientBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretClientBuilderFactory.class);
    private final SecretClientProperties secretClientProperties;

    public SecretClientBuilderFactory(SecretClientProperties secretClientProperties) {
        this.secretClientProperties = secretClientProperties;
    }

    protected BiConsumer<SecretClientBuilder, ClientOptions> consumeClientOptions() {
        return SecretClientBuilder::clientOptions;
    }

    protected BiConsumer<SecretClientBuilder, HttpClient> consumeHttpClient() {
        return SecretClientBuilder::httpClient;
    }

    protected BiConsumer<SecretClientBuilder, HttpPipelinePolicy> consumeHttpPipelinePolicy() {
        return SecretClientBuilder::addPolicy;
    }

    protected BiConsumer<SecretClientBuilder, HttpPipeline> consumeHttpPipeline() {
        return SecretClientBuilder::pipeline;
    }

    protected BiConsumer<SecretClientBuilder, HttpLogOptions> consumeHttpLogOptions() {
        return SecretClientBuilder::httpLogOptions;
    }

    protected SecretClientBuilder createBuilderInstance() {
        return new SecretClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.secretClientProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(SecretClientBuilder builder) {
        AuthenticationDescriptor[] authenticationDescriptorArray = new AuthenticationDescriptor[1];
        authenticationDescriptorArray[0] = new TokenAuthenticationDescriptor(this.tokenCredentialResolver, arg_0 -> ((SecretClientBuilder)builder).credential(arg_0));
        return Arrays.asList(authenticationDescriptorArray);
    }

    protected void configureService(SecretClientBuilder builder) {
        PropertyMapper map = new PropertyMapper();
        map.from((Object)this.secretClientProperties.getEndpoint()).to(arg_0 -> ((SecretClientBuilder)builder).vaultUrl(arg_0));
        map.from((Object)this.secretClientProperties.getServiceVersion()).to(arg_0 -> ((SecretClientBuilder)builder).serviceVersion(arg_0));
        map.from((Object)this.secretClientProperties.isChallengeResourceVerificationEnabled()).whenFalse().to(enabled -> builder.disableChallengeResourceVerification());
    }

    protected BiConsumer<SecretClientBuilder, Configuration> consumeConfiguration() {
        return SecretClientBuilder::configuration;
    }

    protected BiConsumer<SecretClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return SecretClientBuilder::credential;
    }

    protected BiConsumer<SecretClientBuilder, String> consumeConnectionString() {
        LOGGER.debug("Connection string is not supported to configure in SecretClientBuilder");
        return (a, b) -> {};
    }

    protected BiConsumer<SecretClientBuilder, RetryPolicy> consumeRetryPolicy() {
        return SecretClientBuilder::retryPolicy;
    }
}

