/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.redis;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.exceptions.JedisException;

public class AzureJedisFactory
implements PooledObjectFactory<Jedis> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureJedisFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    protected AzureJedisFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public void activateObject(PooledObject<Jedis> pooledJedis) {
        Jedis jedis = (Jedis)pooledJedis.getObject();
        if (jedis.getDB() != this.clientConfig.getDatabase()) {
            jedis.select(this.clientConfig.getDatabase());
        }
    }

    public void destroyObject(PooledObject<Jedis> pooledJedis) {
        Jedis jedis = (Jedis)pooledJedis.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("Error while QUIT", (Throwable)e);
            }
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                LOGGER.warn("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Jedis> makeObject() {
        Jedis jedis = null;
        try {
            jedis = new Jedis(this.jedisSocketFactory, this.clientConfig);
            jedis.connect();
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException jedisException) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Error while QUIT", (Throwable)e);
                }
                try {
                    jedis.close();
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Error while close", (Throwable)e);
                }
            }
            throw jedisException;
        }
    }

    public void passivateObject(PooledObject<Jedis> pooledObject) throws Exception {
    }

    public boolean validateObject(PooledObject<Jedis> pooledJedis) {
        Jedis jedis = (Jedis)pooledJedis.getObject();
        try {
            String host = this.jedisSocketFactory.getHost();
            int port = this.jedisSocketFactory.getPort();
            String connectionHost = jedis.getClient().getHost();
            int connectionPort = jedis.getClient().getPort();
            return host.equals(connectionHost) && port == connectionPort && jedis.isConnected() && jedis.ping().equals("PONG");
        }
        catch (Exception e) {
            LOGGER.error("Error while validating pooled Jedis object.", (Throwable)e);
            return false;
        }
    }
}

