/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.servicebus.factory;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.NamedKeyAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.SasAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.descriptor.TokenAuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureAmqpClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusClientCommonProperties;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusNamespaceProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class ServiceBusClientBuilderFactory
extends AbstractAzureAmqpClientBuilderFactory<ServiceBusClientBuilder> {
    private final ServiceBusClientCommonProperties clientCommonProperties;

    public ServiceBusClientBuilderFactory(ServiceBusClientCommonProperties serviceBusProperties) {
        this.clientCommonProperties = serviceBusProperties;
    }

    protected BiConsumer<ServiceBusClientBuilder, ProxyOptions> consumeProxyOptions() {
        return ServiceBusClientBuilder::proxyOptions;
    }

    protected BiConsumer<ServiceBusClientBuilder, AmqpTransportType> consumeAmqpTransportType() {
        return ServiceBusClientBuilder::transportType;
    }

    protected BiConsumer<ServiceBusClientBuilder, AmqpRetryOptions> consumeAmqpRetryOptions() {
        return ServiceBusClientBuilder::retryOptions;
    }

    protected BiConsumer<ServiceBusClientBuilder, ClientOptions> consumeClientOptions() {
        return ServiceBusClientBuilder::clientOptions;
    }

    protected ServiceBusClientBuilder createBuilderInstance() {
        return new ServiceBusClientBuilder();
    }

    protected AzureProperties getAzureProperties() {
        return this.clientCommonProperties;
    }

    protected List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(ServiceBusClientBuilder builder) {
        return Arrays.asList(new NamedKeyAuthenticationDescriptor(credential -> builder.credential(this.clientCommonProperties.getFullyQualifiedNamespace(), credential)), new SasAuthenticationDescriptor(credential -> builder.credential(this.clientCommonProperties.getFullyQualifiedNamespace(), credential)), new TokenAuthenticationDescriptor(this.tokenCredentialResolver, credential -> builder.credential(this.clientCommonProperties.getFullyQualifiedNamespace(), credential)));
    }

    protected void configureService(ServiceBusClientBuilder builder) {
        PropertyMapper mapper = new PropertyMapper();
        if (this.clientCommonProperties instanceof ServiceBusNamespaceProperties) {
            mapper.from((Object)((ServiceBusNamespaceProperties)this.clientCommonProperties).getCrossEntityTransactions()).whenTrue().to(t -> builder.enableCrossEntityTransactions());
        }
    }

    protected BiConsumer<ServiceBusClientBuilder, Configuration> consumeConfiguration() {
        return ServiceBusClientBuilder::configuration;
    }

    protected BiConsumer<ServiceBusClientBuilder, TokenCredential> consumeDefaultTokenCredential() {
        return (builder, tokenCredential) -> builder.credential(this.clientCommonProperties.getFullyQualifiedNamespace(), tokenCredential);
    }

    protected BiConsumer<ServiceBusClientBuilder, String> consumeConnectionString() {
        return ServiceBusClientBuilder::connectionString;
    }
}

