/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.conditions;

import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cProperties;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.CollectionUtils;

public final class AadB2cConditions {
    private static final String KEY_OF_USER_FLOWS = "user-flows";

    private static AadB2cProperties getAadB2cProperties(ConditionContext context) {
        return (AadB2cProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory.b2c", AadB2cProperties.class).orElse(null);
    }

    private static String getConditionResult(String name, Map<String, ?> map) {
        return name + ": " + String.join((CharSequence)", ", map.keySet()) + " ";
    }

    public static final class UserFlowCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD B2C User Flow Clients Configured Condition", (Object[])new Object[0]);
            AadB2cProperties aadb2CProperties = AadB2cConditions.getAadB2cProperties(context);
            if (aadb2CProperties == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("aad b2c properties"));
            }
            if (CollectionUtils.isEmpty(aadb2CProperties.getUserFlows())) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("user flows").atAll());
            }
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)AadB2cConditions.getConditionResult(AadB2cConditions.KEY_OF_USER_FLOWS, aadb2CProperties.getUserFlows())));
        }
    }

    public static final class ClientRegistrationCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD B2C OAuth 2.0 Clients Configured Condition", (Object[])new Object[0]);
            AadB2cProperties aadb2CProperties = AadB2cConditions.getAadB2cProperties(context);
            if (aadb2CProperties == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("aad b2c properties"));
            }
            if (CollectionUtils.isEmpty(aadb2CProperties.getUserFlows()) && CollectionUtils.isEmpty(aadb2CProperties.getAuthorizationClients())) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("registered clients").items(new Object[]{AadB2cConditions.KEY_OF_USER_FLOWS, "authorization-clients"}));
            }
            StringBuilder details = new StringBuilder();
            if (!CollectionUtils.isEmpty(aadb2CProperties.getUserFlows())) {
                details.append(AadB2cConditions.getConditionResult(AadB2cConditions.KEY_OF_USER_FLOWS, aadb2CProperties.getUserFlows()));
            }
            if (!CollectionUtils.isEmpty(aadb2CProperties.getAuthorizationClients())) {
                details.append(AadB2cConditions.getConditionResult("authorization-clients", aadb2CProperties.getAuthorizationClients()));
            }
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)details.toString()));
        }
    }
}

