/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jdbc;

import com.azure.spring.cloud.autoconfigure.implementation.jdbc.AzureUnsupportedDatabaseTypeException;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.DatabaseType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class JdbcConnectionString {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcConnectionString.class);
    public static final String INVALID_CONNECTION_STRING_FORMAT = "Invalid connection string: %s";
    public static final String UNSUPPORTED_DATABASE_TYPE_STRING_FORMAT = "The DatabaseType specified in : %s is not supported to enhance authentication with Azure AD by Spring Cloud Azure.";
    public static final String INVALID_PROPERTY_PAIR_FORMAT = "Connection string has invalid key value pair: %s";
    private static final String TOKEN_VALUE_SEPARATOR = "=";
    private final String jdbcUrl;
    private final Map<String, String> properties = new HashMap<String, String>();
    private DatabaseType databaseType = null;
    private String baseUrl = null;
    private final List<String> orderedPropertyKeys = new ArrayList<String>();

    private JdbcConnectionString(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    private void resolveSegments() {
        String[] tokenValuePairs;
        if (!StringUtils.hasText((String)this.jdbcUrl)) {
            LOGGER.warn("'connectionString' doesn't have text.");
            throw new IllegalArgumentException(String.format(INVALID_CONNECTION_STRING_FORMAT, this.jdbcUrl));
        }
        Optional<DatabaseType> optionalDatabaseType = Arrays.stream(DatabaseType.values()).filter(databaseType -> this.jdbcUrl.startsWith(databaseType.getSchema() + ":")).findAny();
        this.databaseType = optionalDatabaseType.orElseThrow(() -> new AzureUnsupportedDatabaseTypeException(String.format(UNSUPPORTED_DATABASE_TYPE_STRING_FORMAT, this.jdbcUrl)));
        int pathQueryDelimiterIndex = this.jdbcUrl.indexOf(this.databaseType.getPathQueryDelimiter());
        if (pathQueryDelimiterIndex < 0) {
            this.baseUrl = this.jdbcUrl;
            return;
        }
        this.baseUrl = this.jdbcUrl.substring(0, pathQueryDelimiterIndex);
        String properties = this.jdbcUrl.substring(pathQueryDelimiterIndex + 1);
        for (String tokenValuePair : tokenValuePairs = properties.split(this.databaseType.getQueryDelimiter())) {
            String[] pair = tokenValuePair.split(TOKEN_VALUE_SEPARATOR, 2);
            String key = pair[0];
            if (!StringUtils.hasText((String)pair[0])) {
                throw new IllegalArgumentException(String.format(INVALID_PROPERTY_PAIR_FORMAT, tokenValuePair));
            }
            if (pair.length < 2) {
                this.properties.put(key, null);
            } else {
                this.properties.put(key, pair[1]);
            }
            this.orderedPropertyKeys.add(key);
        }
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    String getProperty(String key) {
        return this.properties.get(key);
    }

    Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    List<String> getOrderedPropertyKeys() {
        return Collections.unmodifiableList(this.orderedPropertyKeys);
    }

    public static JdbcConnectionString resolve(String url) {
        JdbcConnectionString jdbcConnectionString = new JdbcConnectionString(url);
        try {
            jdbcConnectionString.resolveSegments();
        }
        catch (AzureUnsupportedDatabaseTypeException e) {
            LOGGER.debug(e.getMessage());
            return null;
        }
        return jdbcConnectionString;
    }
}

