/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.AccountLimits;
import com.azure.resourcemanager.storage.models.AccountUsage;
import com.azure.resourcemanager.storage.models.BurstingConstants;
import com.azure.resourcemanager.storage.models.FileShareLimits;
import com.azure.resourcemanager.storage.models.FileShareRecommendations;
import java.io.IOException;

public final class FileServiceUsageProperties
implements JsonSerializable<FileServiceUsageProperties> {
    private AccountLimits storageAccountLimits;
    private FileShareLimits fileShareLimits;
    private FileShareRecommendations fileShareRecommendations;
    private BurstingConstants burstingConstants;
    private AccountUsage storageAccountUsage;

    public AccountLimits storageAccountLimits() {
        return this.storageAccountLimits;
    }

    public FileShareLimits fileShareLimits() {
        return this.fileShareLimits;
    }

    public FileShareRecommendations fileShareRecommendations() {
        return this.fileShareRecommendations;
    }

    public BurstingConstants burstingConstants() {
        return this.burstingConstants;
    }

    public AccountUsage storageAccountUsage() {
        return this.storageAccountUsage;
    }

    public void validate() {
        if (this.storageAccountLimits() != null) {
            this.storageAccountLimits().validate();
        }
        if (this.fileShareLimits() != null) {
            this.fileShareLimits().validate();
        }
        if (this.fileShareRecommendations() != null) {
            this.fileShareRecommendations().validate();
        }
        if (this.burstingConstants() != null) {
            this.burstingConstants().validate();
        }
        if (this.storageAccountUsage() != null) {
            this.storageAccountUsage().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static FileServiceUsageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileServiceUsageProperties)jsonReader.readObject(reader -> {
            FileServiceUsageProperties deserializedFileServiceUsageProperties = new FileServiceUsageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountLimits".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.storageAccountLimits = AccountLimits.fromJson(reader);
                    continue;
                }
                if ("fileShareLimits".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.fileShareLimits = FileShareLimits.fromJson(reader);
                    continue;
                }
                if ("fileShareRecommendations".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.fileShareRecommendations = FileShareRecommendations.fromJson(reader);
                    continue;
                }
                if ("burstingConstants".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.burstingConstants = BurstingConstants.fromJson(reader);
                    continue;
                }
                if ("storageAccountUsage".equals(fieldName)) {
                    deserializedFileServiceUsageProperties.storageAccountUsage = AccountUsage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileServiceUsageProperties;
        });
    }
}

