/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.BlobInventoryCreationTime;
import java.io.IOException;
import java.util.List;

public final class BlobInventoryPolicyFilter
implements JsonSerializable<BlobInventoryPolicyFilter> {
    private List<String> prefixMatch;
    private List<String> excludePrefix;
    private List<String> blobTypes;
    private Boolean includeBlobVersions;
    private Boolean includeSnapshots;
    private Boolean includeDeleted;
    private BlobInventoryCreationTime creationTime;

    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    public BlobInventoryPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    public List<String> excludePrefix() {
        return this.excludePrefix;
    }

    public BlobInventoryPolicyFilter withExcludePrefix(List<String> excludePrefix) {
        this.excludePrefix = excludePrefix;
        return this;
    }

    public List<String> blobTypes() {
        return this.blobTypes;
    }

    public BlobInventoryPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    public Boolean includeBlobVersions() {
        return this.includeBlobVersions;
    }

    public BlobInventoryPolicyFilter withIncludeBlobVersions(Boolean includeBlobVersions) {
        this.includeBlobVersions = includeBlobVersions;
        return this;
    }

    public Boolean includeSnapshots() {
        return this.includeSnapshots;
    }

    public BlobInventoryPolicyFilter withIncludeSnapshots(Boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public BlobInventoryPolicyFilter withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    public BlobInventoryCreationTime creationTime() {
        return this.creationTime;
    }

    public BlobInventoryPolicyFilter withCreationTime(BlobInventoryCreationTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public void validate() {
        if (this.creationTime() != null) {
            this.creationTime().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludePrefix", this.excludePrefix, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("includeBlobVersions", this.includeBlobVersions);
        jsonWriter.writeBooleanField("includeSnapshots", this.includeSnapshots);
        jsonWriter.writeBooleanField("includeDeleted", this.includeDeleted);
        jsonWriter.writeJsonField("creationTime", (JsonSerializable)this.creationTime);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return (BlobInventoryPolicyFilter)jsonReader.readObject(reader -> {
            BlobInventoryPolicyFilter deserializedBlobInventoryPolicyFilter = new BlobInventoryPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prefixMatch".equals(fieldName)) {
                    List prefixMatch;
                    deserializedBlobInventoryPolicyFilter.prefixMatch = prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludePrefix".equals(fieldName)) {
                    List excludePrefix;
                    deserializedBlobInventoryPolicyFilter.excludePrefix = excludePrefix = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("blobTypes".equals(fieldName)) {
                    List blobTypes;
                    deserializedBlobInventoryPolicyFilter.blobTypes = blobTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("includeBlobVersions".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeBlobVersions = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeSnapshots".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeSnapshots = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeDeleted".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeDeleted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.creationTime = BlobInventoryCreationTime.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyFilter;
        });
    }
}

