/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.CorsRules;
import com.azure.resourcemanager.storage.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.storage.models.ProtocolSettings;
import java.io.IOException;

public final class FileServicePropertiesProperties
implements JsonSerializable<FileServicePropertiesProperties> {
    private CorsRules cors;
    private DeleteRetentionPolicy shareDeleteRetentionPolicy;
    private ProtocolSettings protocolSettings;

    public CorsRules cors() {
        return this.cors;
    }

    public FileServicePropertiesProperties withCors(CorsRules cors) {
        this.cors = cors;
        return this;
    }

    public DeleteRetentionPolicy shareDeleteRetentionPolicy() {
        return this.shareDeleteRetentionPolicy;
    }

    public FileServicePropertiesProperties withShareDeleteRetentionPolicy(DeleteRetentionPolicy shareDeleteRetentionPolicy) {
        this.shareDeleteRetentionPolicy = shareDeleteRetentionPolicy;
        return this;
    }

    public ProtocolSettings protocolSettings() {
        return this.protocolSettings;
    }

    public FileServicePropertiesProperties withProtocolSettings(ProtocolSettings protocolSettings) {
        this.protocolSettings = protocolSettings;
        return this;
    }

    public void validate() {
        if (this.cors() != null) {
            this.cors().validate();
        }
        if (this.shareDeleteRetentionPolicy() != null) {
            this.shareDeleteRetentionPolicy().validate();
        }
        if (this.protocolSettings() != null) {
            this.protocolSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("cors", (JsonSerializable)this.cors);
        jsonWriter.writeJsonField("shareDeleteRetentionPolicy", (JsonSerializable)this.shareDeleteRetentionPolicy);
        jsonWriter.writeJsonField("protocolSettings", (JsonSerializable)this.protocolSettings);
        return jsonWriter.writeEndObject();
    }

    public static FileServicePropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileServicePropertiesProperties)jsonReader.readObject(reader -> {
            FileServicePropertiesProperties deserializedFileServicePropertiesProperties = new FileServicePropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cors".equals(fieldName)) {
                    deserializedFileServicePropertiesProperties.cors = CorsRules.fromJson(reader);
                    continue;
                }
                if ("shareDeleteRetentionPolicy".equals(fieldName)) {
                    deserializedFileServicePropertiesProperties.shareDeleteRetentionPolicy = DeleteRetentionPolicy.fromJson(reader);
                    continue;
                }
                if ("protocolSettings".equals(fieldName)) {
                    deserializedFileServicePropertiesProperties.protocolSettings = ProtocolSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileServicePropertiesProperties;
        });
    }
}

