/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.EncryptionInTransit;
import com.azure.resourcemanager.storage.models.Multichannel;
import java.io.IOException;

public final class SmbSetting
implements JsonSerializable<SmbSetting> {
    private Multichannel multichannel;
    private String versions;
    private String authenticationMethods;
    private String kerberosTicketEncryption;
    private String channelEncryption;
    private EncryptionInTransit encryptionInTransit;

    public Multichannel multichannel() {
        return this.multichannel;
    }

    public SmbSetting withMultichannel(Multichannel multichannel) {
        this.multichannel = multichannel;
        return this;
    }

    public String versions() {
        return this.versions;
    }

    public SmbSetting withVersions(String versions) {
        this.versions = versions;
        return this;
    }

    public String authenticationMethods() {
        return this.authenticationMethods;
    }

    public SmbSetting withAuthenticationMethods(String authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public String kerberosTicketEncryption() {
        return this.kerberosTicketEncryption;
    }

    public SmbSetting withKerberosTicketEncryption(String kerberosTicketEncryption) {
        this.kerberosTicketEncryption = kerberosTicketEncryption;
        return this;
    }

    public String channelEncryption() {
        return this.channelEncryption;
    }

    public SmbSetting withChannelEncryption(String channelEncryption) {
        this.channelEncryption = channelEncryption;
        return this;
    }

    public EncryptionInTransit encryptionInTransit() {
        return this.encryptionInTransit;
    }

    public SmbSetting withEncryptionInTransit(EncryptionInTransit encryptionInTransit) {
        this.encryptionInTransit = encryptionInTransit;
        return this;
    }

    public void validate() {
        if (this.multichannel() != null) {
            this.multichannel().validate();
        }
        if (this.encryptionInTransit() != null) {
            this.encryptionInTransit().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("multichannel", (JsonSerializable)this.multichannel);
        jsonWriter.writeStringField("versions", this.versions);
        jsonWriter.writeStringField("authenticationMethods", this.authenticationMethods);
        jsonWriter.writeStringField("kerberosTicketEncryption", this.kerberosTicketEncryption);
        jsonWriter.writeStringField("channelEncryption", this.channelEncryption);
        jsonWriter.writeJsonField("encryptionInTransit", (JsonSerializable)this.encryptionInTransit);
        return jsonWriter.writeEndObject();
    }

    public static SmbSetting fromJson(JsonReader jsonReader) throws IOException {
        return (SmbSetting)jsonReader.readObject(reader -> {
            SmbSetting deserializedSmbSetting = new SmbSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("multichannel".equals(fieldName)) {
                    deserializedSmbSetting.multichannel = Multichannel.fromJson(reader);
                    continue;
                }
                if ("versions".equals(fieldName)) {
                    deserializedSmbSetting.versions = reader.getString();
                    continue;
                }
                if ("authenticationMethods".equals(fieldName)) {
                    deserializedSmbSetting.authenticationMethods = reader.getString();
                    continue;
                }
                if ("kerberosTicketEncryption".equals(fieldName)) {
                    deserializedSmbSetting.kerberosTicketEncryption = reader.getString();
                    continue;
                }
                if ("channelEncryption".equals(fieldName)) {
                    deserializedSmbSetting.channelEncryption = reader.getString();
                    continue;
                }
                if ("encryptionInTransit".equals(fieldName)) {
                    deserializedSmbSetting.encryptionInTransit = EncryptionInTransit.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmbSetting;
        });
    }
}

