/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyProperty;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import java.io.IOException;

public final class ImmutabilityPolicyInner
extends AzureEntityResource {
    private ImmutabilityPolicyProperty innerProperties = new ImmutabilityPolicyProperty();
    private String etag;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ImmutabilityPolicyInner.class);

    private ImmutabilityPolicyProperty innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().immutabilityPeriodSinceCreationInDays();
    }

    public ImmutabilityPolicyInner withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this;
    }

    public ImmutabilityPolicyState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Boolean allowProtectedAppendWrites() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWrites();
    }

    public ImmutabilityPolicyInner withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        return this;
    }

    public Boolean allowProtectedAppendWritesAll() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWritesAll();
    }

    public ImmutabilityPolicyInner withAllowProtectedAppendWritesAll(Boolean allowProtectedAppendWritesAll) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWritesAll(allowProtectedAppendWritesAll);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ImmutabilityPolicyInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ImmutabilityPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ImmutabilityPolicyInner)((Object)jsonReader.readObject(reader -> {
            ImmutabilityPolicyInner deserializedImmutabilityPolicyInner = new ImmutabilityPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedImmutabilityPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedImmutabilityPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedImmutabilityPolicyInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedImmutabilityPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedImmutabilityPolicyInner.innerProperties = ImmutabilityPolicyProperty.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImmutabilityPolicyInner;
        }));
    }
}

