/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.servicebus.fluent.DisasterRecoveryConfigsClient;
import com.azure.resourcemanager.servicebus.fluent.EventHubsClient;
import com.azure.resourcemanager.servicebus.fluent.MigrationConfigsClient;
import com.azure.resourcemanager.servicebus.fluent.NamespacesClient;
import com.azure.resourcemanager.servicebus.fluent.OperationsClient;
import com.azure.resourcemanager.servicebus.fluent.PremiumMessagingRegionsClient;
import com.azure.resourcemanager.servicebus.fluent.QueuesClient;
import com.azure.resourcemanager.servicebus.fluent.RegionsClient;
import com.azure.resourcemanager.servicebus.fluent.RulesClient;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.SubscriptionsClient;
import com.azure.resourcemanager.servicebus.fluent.TopicsClient;
import com.azure.resourcemanager.servicebus.implementation.DisasterRecoveryConfigsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.EventHubsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.MigrationConfigsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.servicebus.implementation.OperationsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.PremiumMessagingRegionsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.QueuesClientImpl;
import com.azure.resourcemanager.servicebus.implementation.RegionsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.RulesClientImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientBuilder;
import com.azure.resourcemanager.servicebus.implementation.SubscriptionsClientImpl;
import com.azure.resourcemanager.servicebus.implementation.TopicsClientImpl;
import java.time.Duration;

@ServiceClient(builder=ServiceBusManagementClientBuilder.class)
public final class ServiceBusManagementClientImpl
extends AzureServiceClient
implements ServiceBusManagementClient {
    private final ClientLogger logger = new ClientLogger(ServiceBusManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final NamespacesClient namespaces;
    private final QueuesClient queues;
    private final TopicsClient topics;
    private final DisasterRecoveryConfigsClient disasterRecoveryConfigs;
    private final EventHubsClient eventHubs;
    private final MigrationConfigsClient migrationConfigs;
    private final OperationsClient operations;
    private final PremiumMessagingRegionsClient premiumMessagingRegions;
    private final RulesClient rules;
    private final RegionsClient regions;
    private final SubscriptionsClient subscriptions;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public QueuesClient getQueues() {
        return this.queues;
    }

    @Override
    public TopicsClient getTopics() {
        return this.topics;
    }

    @Override
    public DisasterRecoveryConfigsClient getDisasterRecoveryConfigs() {
        return this.disasterRecoveryConfigs;
    }

    @Override
    public EventHubsClient getEventHubs() {
        return this.eventHubs;
    }

    @Override
    public MigrationConfigsClient getMigrationConfigs() {
        return this.migrationConfigs;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public PremiumMessagingRegionsClient getPremiumMessagingRegions() {
        return this.premiumMessagingRegions;
    }

    @Override
    public RulesClient getRules() {
        return this.rules;
    }

    @Override
    public RegionsClient getRegions() {
        return this.regions;
    }

    @Override
    public SubscriptionsClient getSubscriptions() {
        return this.subscriptions;
    }

    ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2017-04-01";
        this.namespaces = new NamespacesClientImpl(this);
        this.queues = new QueuesClientImpl(this);
        this.topics = new TopicsClientImpl(this);
        this.disasterRecoveryConfigs = new DisasterRecoveryConfigsClientImpl(this);
        this.eventHubs = new EventHubsClientImpl(this);
        this.migrationConfigs = new MigrationConfigsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.premiumMessagingRegions = new PremiumMessagingRegionsClientImpl(this);
        this.rules = new RulesClientImpl(this);
        this.regions = new RegionsClientImpl(this);
        this.subscriptions = new SubscriptionsClientImpl(this);
    }
}

