/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.implementation.DurationSerializer;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.azure.resourcemanager.servicebus.models.SBClientAffineProperties;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SBSubscriptionProperties
implements JsonSerializable<SBSubscriptionProperties> {
    private Long messageCount;
    private OffsetDateTime createdAt;
    private OffsetDateTime accessedAt;
    private OffsetDateTime updatedAt;
    private MessageCountDetails countDetails;
    private Duration lockDuration;
    private Boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private Boolean deadLetteringOnFilterEvaluationExceptions;
    private Boolean deadLetteringOnMessageExpiration;
    private Duration duplicateDetectionHistoryTimeWindow;
    private Integer maxDeliveryCount;
    private EntityStatus status;
    private Boolean enableBatchedOperations;
    private Duration autoDeleteOnIdle;
    private String forwardTo;
    private String forwardDeadLetteredMessagesTo;
    private Boolean isClientAffine;
    private SBClientAffineProperties clientAffineProperties;

    public Long messageCount() {
        return this.messageCount;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public Duration lockDuration() {
        return this.lockDuration;
    }

    public SBSubscriptionProperties withLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Boolean requiresSession() {
        return this.requiresSession;
    }

    public SBSubscriptionProperties withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SBSubscriptionProperties withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean deadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SBSubscriptionProperties withDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SBSubscriptionProperties withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public SBSubscriptionProperties withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SBSubscriptionProperties withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SBSubscriptionProperties withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SBSubscriptionProperties withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SBSubscriptionProperties withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public String forwardTo() {
        return this.forwardTo;
    }

    public SBSubscriptionProperties withForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String forwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SBSubscriptionProperties withForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Boolean isClientAffine() {
        return this.isClientAffine;
    }

    public SBSubscriptionProperties withIsClientAffine(Boolean isClientAffine) {
        this.isClientAffine = isClientAffine;
        return this;
    }

    public SBClientAffineProperties clientAffineProperties() {
        return this.clientAffineProperties;
    }

    public SBSubscriptionProperties withClientAffineProperties(SBClientAffineProperties clientAffineProperties) {
        this.clientAffineProperties = clientAffineProperties;
        return this;
    }

    public void validate() {
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
        if (this.clientAffineProperties() != null) {
            this.clientAffineProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockDuration", CoreUtils.durationToStringWithDays((Duration)this.lockDuration));
        jsonWriter.writeBooleanField("requiresSession", this.requiresSession);
        jsonWriter.writeStringField("defaultMessageTimeToLive", DurationSerializer.serialize(this.defaultMessageTimeToLive));
        jsonWriter.writeBooleanField("deadLetteringOnFilterEvaluationExceptions", this.deadLetteringOnFilterEvaluationExceptions);
        jsonWriter.writeBooleanField("deadLetteringOnMessageExpiration", this.deadLetteringOnMessageExpiration);
        jsonWriter.writeStringField("duplicateDetectionHistoryTimeWindow", DurationSerializer.serialize(this.duplicateDetectionHistoryTimeWindow));
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeBooleanField("enableBatchedOperations", this.enableBatchedOperations);
        jsonWriter.writeStringField("autoDeleteOnIdle", DurationSerializer.serialize(this.autoDeleteOnIdle));
        jsonWriter.writeStringField("forwardTo", this.forwardTo);
        jsonWriter.writeStringField("forwardDeadLetteredMessagesTo", this.forwardDeadLetteredMessagesTo);
        jsonWriter.writeBooleanField("isClientAffine", this.isClientAffine);
        jsonWriter.writeJsonField("clientAffineProperties", (JsonSerializable)this.clientAffineProperties);
        return jsonWriter.writeEndObject();
    }

    public static SBSubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SBSubscriptionProperties)jsonReader.readObject(reader -> {
            SBSubscriptionProperties deserializedSBSubscriptionProperties = new SBSubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messageCount".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.messageCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("accessedAt".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.accessedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.updatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("countDetails".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.countDetails = MessageCountDetails.fromJson(reader);
                    continue;
                }
                if ("lockDuration".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.lockDuration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("requiresSession".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.requiresSession = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultMessageTimeToLive".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.defaultMessageTimeToLive = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("deadLetteringOnFilterEvaluationExceptions".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.deadLetteringOnFilterEvaluationExceptions = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deadLetteringOnMessageExpiration".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.deadLetteringOnMessageExpiration = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("duplicateDetectionHistoryTimeWindow".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.duplicateDetectionHistoryTimeWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("enableBatchedOperations".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.enableBatchedOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDeleteOnIdle".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.autoDeleteOnIdle = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("forwardTo".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.forwardTo = reader.getString();
                    continue;
                }
                if ("forwardDeadLetteredMessagesTo".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.forwardDeadLetteredMessagesTo = reader.getString();
                    continue;
                }
                if ("isClientAffine".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.isClientAffine = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientAffineProperties".equals(fieldName)) {
                    deserializedSBSubscriptionProperties.clientAffineProperties = SBClientAffineProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBSubscriptionProperties;
        });
    }
}

