// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Description of a Check Name availability request properties.
 */
@Fluent
public final class CheckNameAvailability implements JsonSerializable<CheckNameAvailability> {
    /*
     * The Name to check the namespace name availability and The namespace name can contain only letters, numbers, and
     * hyphens. The namespace must start with a letter, and it must end with a letter or number.
     */
    private String name;

    /**
     * Creates an instance of CheckNameAvailability class.
     */
    public CheckNameAvailability() {
    }

    /**
     * Get the name property: The Name to check the namespace name availability and The namespace name can contain only
     * letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The Name to check the namespace name availability and The namespace name can contain only
     * letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * 
     * @param name the name value to set.
     * @return the CheckNameAvailability object itself.
     */
    public CheckNameAvailability withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model CheckNameAvailability"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailability.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckNameAvailability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckNameAvailability if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CheckNameAvailability.
     */
    public static CheckNameAvailability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckNameAvailability deserializedCheckNameAvailability = new CheckNameAvailability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCheckNameAvailability.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckNameAvailability;
        });
    }
}
