// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.Action;
import com.azure.resourcemanager.servicebus.models.CorrelationFilter;
import com.azure.resourcemanager.servicebus.models.FilterType;
import com.azure.resourcemanager.servicebus.models.SqlFilter;
import java.io.IOException;

/**
 * Description of Rule Resource.
 */
@Fluent
public final class RuleInner extends ProxyResource {
    /*
     * Properties of Rule resource
     */
    private Ruleproperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of RuleInner class.
     */
    public RuleInner() {
    }

    /**
     * Get the innerProperties property: Properties of Rule resource.
     * 
     * @return the innerProperties value.
     */
    private Ruleproperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the action property: Represents the filter actions which are allowed for the transformation of a message that
     * have been matched by a filter expression.
     * 
     * @return the action value.
     */
    public Action action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    /**
     * Set the action property: Represents the filter actions which are allowed for the transformation of a message that
     * have been matched by a filter expression.
     * 
     * @param action the action value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withAction(Action action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    /**
     * Get the filterType property: Filter type that is evaluated against a BrokeredMessage.
     * 
     * @return the filterType value.
     */
    public FilterType filterType() {
        return this.innerProperties() == null ? null : this.innerProperties().filterType();
    }

    /**
     * Set the filterType property: Filter type that is evaluated against a BrokeredMessage.
     * 
     * @param filterType the filterType value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withFilterType(FilterType filterType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withFilterType(filterType);
        return this;
    }

    /**
     * Get the sqlFilter property: Properties of sqlFilter.
     * 
     * @return the sqlFilter value.
     */
    public SqlFilter sqlFilter() {
        return this.innerProperties() == null ? null : this.innerProperties().sqlFilter();
    }

    /**
     * Set the sqlFilter property: Properties of sqlFilter.
     * 
     * @param sqlFilter the sqlFilter value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withSqlFilter(SqlFilter sqlFilter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withSqlFilter(sqlFilter);
        return this;
    }

    /**
     * Get the correlationFilter property: Properties of correlationFilter.
     * 
     * @return the correlationFilter value.
     */
    public CorrelationFilter correlationFilter() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationFilter();
    }

    /**
     * Set the correlationFilter property: Properties of correlationFilter.
     * 
     * @param correlationFilter the correlationFilter value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withCorrelationFilter(CorrelationFilter correlationFilter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withCorrelationFilter(correlationFilter);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuleInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RuleInner.
     */
    public static RuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuleInner deserializedRuleInner = new RuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRuleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRuleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRuleInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRuleInner.innerProperties = Ruleproperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedRuleInner.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedRuleInner.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuleInner;
        });
    }
}
