/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import java.io.IOException;
import java.util.List;

public final class SubscriptionListResult
implements JsonSerializable<SubscriptionListResult> {
    private List<SubscriptionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionListResult.class);

    public List<SubscriptionInner> value() {
        return this.value;
    }

    public SubscriptionListResult withValue(List<SubscriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SubscriptionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
        if (this.nextLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nextLink in model SubscriptionListResult"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionListResult)jsonReader.readObject(reader -> {
            SubscriptionListResult deserializedSubscriptionListResult = new SubscriptionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedSubscriptionListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSubscriptionListResult.value = value = reader.readArray(reader1 -> SubscriptionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionListResult;
        });
    }
}

