/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.models.ResourceGroupInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.implementation.ResourceGroupImpl;
import com.azure.resourcemanager.resources.models.ForceDeletionResourceType;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ResourceGroupsImpl
extends CreatableResourcesImpl<ResourceGroup, ResourceGroupImpl, ResourceGroupInner>
implements ResourceGroups {
    private final ClientLogger logger = new ClientLogger(ResourceGroupsImpl.class);
    private final ResourceManager resourceManager;

    public ResourceGroupsImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public PagedIterable<ResourceGroup> list() {
        return this.wrapList(((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().list());
    }

    @Override
    public PagedIterable<ResourceGroup> listByTag(String tagName, String tagValue) {
        return new PagedIterable(this.listByTagAsync(tagName, tagValue));
    }

    @Override
    public PagedFlux<ResourceGroup> listByTagAsync(String tagName, String tagValue) {
        return this.wrapPageAsync(((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().listAsync(ResourceManagerUtils.createOdataFilterForTags(tagName, tagValue), null));
    }

    @Override
    public ResourceGroupImpl getByName(String name) {
        return this.wrapModel(((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().get(name));
    }

    @Override
    public Mono<ResourceGroup> getByNameAsync(String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().getAsync(name).map(this::wrapModel);
    }

    @Override
    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    @Override
    public Mono<Void> deleteByNameAsync(String name, Collection<ForceDeletionResourceType> forceDeletionResourceTypes) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().deleteAsync(name, ResourceGroupsImpl.forceDeletionTypes(forceDeletionResourceTypes));
    }

    @Override
    public void deleteByName(String name, Collection<ForceDeletionResourceType> forceDeletionResourceTypes) {
        this.deleteByNameAsync(name, forceDeletionResourceTypes).block();
    }

    @Override
    public Mono<Void> deleteByNameAsync(String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().deleteAsync(name);
    }

    @Override
    public ResourceGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public boolean contain(String name) {
        return ((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().checkExistence(name);
    }

    @Override
    protected ResourceGroupImpl wrapModel(String name) {
        return new ResourceGroupImpl(new ResourceGroupInner(), name, (ResourceManagementClient)this.manager().serviceClient());
    }

    @Override
    protected ResourceGroupImpl wrapModel(ResourceGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ResourceGroupImpl(inner, inner.name(), (ResourceManagementClient)this.manager().serviceClient());
    }

    @Override
    public Accepted<Void> beginDeleteByName(String name) {
        return this.beginDeleteByName(name, Context.NONE);
    }

    @Override
    public Accepted<Void> beginDeleteByName(String name, Context context) {
        return this.beginDeleteByName(name, null, context);
    }

    @Override
    public Accepted<Void> beginDeleteByName(String name, Collection<ForceDeletionResourceType> forceDeletionResourceTypes) {
        return this.beginDeleteByName(name, forceDeletionResourceTypes, Context.NONE);
    }

    @Override
    public Accepted<Void> beginDeleteByName(String name, Collection<ForceDeletionResourceType> forceDeletionResourceTypes, Context context) {
        return AcceptedImpl.newAccepted(this.logger, ((ResourceManagementClient)this.manager().serviceClient()).getHttpPipeline(), ((ResourceManagementClient)this.manager().serviceClient()).getDefaultPollInterval(), () -> (Response)((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().deleteWithResponseAsync(name, ResourceGroupsImpl.forceDeletionTypes(forceDeletionResourceTypes)).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).block(), Function.identity(), Void.class, null, context);
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public PagedFlux<ResourceGroup> listAsync() {
        return PagedConverter.mapPage(((ResourceManagementClient)this.manager().serviceClient()).getResourceGroups().listAsync(), inner -> this.wrapModel((ResourceGroupInner)((Object)inner)));
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    private static String forceDeletionTypes(Collection<ForceDeletionResourceType> forceDeletionResourceTypes) {
        String typesInStr = null;
        if (forceDeletionResourceTypes != null && !forceDeletionResourceTypes.isEmpty()) {
            typesInStr = forceDeletionResourceTypes.stream().map(ExpandableStringEnum::toString).collect(Collectors.joining(","));
        }
        return typesInStr;
    }
}

