/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.utils;

import com.azure.core.http.HttpHeaders;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceManagerThrottlingInfo {
    private static final List<String> COMMON_RATE_LIMIT_HEADERS = Arrays.asList("x-ms-ratelimit-remaining-subscription-reads", "x-ms-ratelimit-remaining-subscription-writes", "x-ms-ratelimit-remaining-tenant-reads", "x-ms-ratelimit-remaining-tenant-writes", "x-ms-ratelimit-remaining-subscription-resource-requests", "x-ms-ratelimit-remaining-subscription-resource-entities-read", "x-ms-ratelimit-remaining-tenant-resource-requests", "x-ms-ratelimit-remaining-tenant-resource-entities-read");
    private static final String RESOURCE_RATE_LIMIT_HEADER = "x-ms-ratelimit-remaining-resource";
    private static final Pattern RESOURCE_RATE_LIMIT_HEADER_PATTERN = Pattern.compile("\\w+\\.\\w+/([^;]+);(\\d+)");
    private final Map<String, String> commonRateLimits = new HashMap<String, String>();
    private final String resourceRateLimit;

    public ResourceManagerThrottlingInfo(HttpHeaders headers) {
        for (String header : COMMON_RATE_LIMIT_HEADERS) {
            String value = headers.getValue(header);
            if (value == null || value.isEmpty()) continue;
            this.commonRateLimits.put(header, value);
        }
        this.resourceRateLimit = headers.getValue(RESOURCE_RATE_LIMIT_HEADER);
        if (this.resourceRateLimit != null) {
            Matcher matcher = RESOURCE_RATE_LIMIT_HEADER_PATTERN.matcher(this.resourceRateLimit);
            while (matcher.find()) {
                this.commonRateLimits.put(String.format("%s-%s", RESOURCE_RATE_LIMIT_HEADER, matcher.group(1)), matcher.group(2));
            }
        }
    }

    public static ResourceManagerThrottlingInfo fromHeaders(HttpHeaders headers) {
        return new ResourceManagerThrottlingInfo(headers);
    }

    public Optional<Integer> getRateLimit() {
        Optional<Integer> result = Optional.empty();
        for (Map.Entry<String, String> limits : this.commonRateLimits.entrySet()) {
            try {
                int limit = Integer.parseInt(limits.getValue());
                if (result.isPresent() && result.get() <= limit) continue;
                result = Optional.of(limit);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public Map<String, String> getRateLimits() {
        return Collections.unmodifiableMap(this.commonRateLimits);
    }

    public String getResourceRateLimit() {
        return this.resourceRateLimit;
    }
}

