/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.PolicyAssignmentProperties;
import com.azure.resourcemanager.resources.models.EnforcementMode;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.NonComplianceMessage;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicyAssignmentInner
extends ProxyResource {
    private PolicyAssignmentProperties innerProperties;
    private String location;
    private Identity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PolicyAssignmentProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public PolicyAssignmentInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public PolicyAssignmentInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public PolicyAssignmentInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String policyDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionId();
    }

    public PolicyAssignmentInner withPolicyDefinitionId(String policyDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withPolicyDefinitionId(policyDefinitionId);
        return this;
    }

    public String definitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().definitionVersion();
    }

    public PolicyAssignmentInner withDefinitionVersion(String definitionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDefinitionVersion(definitionVersion);
        return this;
    }

    public String latestDefinitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().latestDefinitionVersion();
    }

    public String effectiveDefinitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveDefinitionVersion();
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public List<String> notScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().notScopes();
    }

    public PolicyAssignmentInner withNotScopes(List<String> notScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withNotScopes(notScopes);
        return this;
    }

    public Map<String, ParameterValuesValue> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public PolicyAssignmentInner withParameters(Map<String, ParameterValuesValue> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public PolicyAssignmentInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public PolicyAssignmentInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public EnforcementMode enforcementMode() {
        return this.innerProperties() == null ? null : this.innerProperties().enforcementMode();
    }

    public PolicyAssignmentInner withEnforcementMode(EnforcementMode enforcementMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withEnforcementMode(enforcementMode);
        return this;
    }

    public List<NonComplianceMessage> nonComplianceMessages() {
        return this.innerProperties() == null ? null : this.innerProperties().nonComplianceMessages();
    }

    public PolicyAssignmentInner withNonComplianceMessages(List<NonComplianceMessage> nonComplianceMessages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withNonComplianceMessages(nonComplianceMessages);
        return this;
    }

    public List<ResourceSelector> resourceSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceSelectors();
    }

    public PolicyAssignmentInner withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withResourceSelectors(resourceSelectors);
        return this;
    }

    public List<OverrideModel> overrides() {
        return this.innerProperties() == null ? null : this.innerProperties().overrides();
    }

    public PolicyAssignmentInner withOverrides(List<OverrideModel> overrides) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withOverrides(overrides);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentInner)((Object)jsonReader.readObject(reader -> {
            PolicyAssignmentInner deserializedPolicyAssignmentInner = new PolicyAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.innerProperties = PolicyAssignmentProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentInner;
        }));
    }
}

