/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DenyStatusMode;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceStatusMode;
import java.io.IOException;

public final class ManagedResourceReference
extends ResourceReference {
    private ResourceStatusMode status;
    private DenyStatusMode denyStatus;
    private String id;

    public ResourceStatusMode status() {
        return this.status;
    }

    public ManagedResourceReference withStatus(ResourceStatusMode status) {
        this.status = status;
        return this;
    }

    public DenyStatusMode denyStatus() {
        return this.denyStatus;
    }

    public ManagedResourceReference withDenyStatus(DenyStatusMode denyStatus) {
        this.denyStatus = denyStatus;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("denyStatus", this.denyStatus == null ? null : this.denyStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedResourceReference fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedResourceReference)jsonReader.readObject(reader -> {
            ManagedResourceReference deserializedManagedResourceReference = new ManagedResourceReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedResourceReference.id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedResourceReference.status = ResourceStatusMode.fromString(reader.getString());
                    continue;
                }
                if ("denyStatus".equals(fieldName)) {
                    deserializedManagedResourceReference.denyStatus = DenyStatusMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedResourceReference;
        });
    }
}

