/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ExtensionConfigPropertyType;
import com.azure.resourcemanager.resources.models.KeyVaultParameterReference;
import java.io.IOException;

public final class DeploymentExtensionConfigItem
implements JsonSerializable<DeploymentExtensionConfigItem> {
    private ExtensionConfigPropertyType type;
    private Object value;
    private KeyVaultParameterReference keyVaultReference;

    public ExtensionConfigPropertyType type() {
        return this.type;
    }

    public Object value() {
        return this.value;
    }

    public DeploymentExtensionConfigItem withValue(Object value) {
        this.value = value;
        return this;
    }

    public KeyVaultParameterReference keyVaultReference() {
        return this.keyVaultReference;
    }

    public DeploymentExtensionConfigItem withKeyVaultReference(KeyVaultParameterReference keyVaultReference) {
        this.keyVaultReference = keyVaultReference;
        return this;
    }

    public void validate() {
        if (this.keyVaultReference() != null) {
            this.keyVaultReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeJsonField("keyVaultReference", (JsonSerializable)this.keyVaultReference);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentExtensionConfigItem fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentExtensionConfigItem)jsonReader.readObject(reader -> {
            DeploymentExtensionConfigItem deserializedDeploymentExtensionConfigItem = new DeploymentExtensionConfigItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.type = ExtensionConfigPropertyType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.value = reader.readUntyped();
                    continue;
                }
                if ("keyVaultReference".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.keyVaultReference = KeyVaultParameterReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentExtensionConfigItem;
        });
    }
}

