/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DenySettingsMode;
import java.io.IOException;
import java.util.List;

public final class DenySettings
implements JsonSerializable<DenySettings> {
    private DenySettingsMode mode;
    private List<String> excludedPrincipals;
    private List<String> excludedActions;
    private Boolean applyToChildScopes;
    private static final ClientLogger LOGGER = new ClientLogger(DenySettings.class);

    public DenySettingsMode mode() {
        return this.mode;
    }

    public DenySettings withMode(DenySettingsMode mode) {
        this.mode = mode;
        return this;
    }

    public List<String> excludedPrincipals() {
        return this.excludedPrincipals;
    }

    public DenySettings withExcludedPrincipals(List<String> excludedPrincipals) {
        this.excludedPrincipals = excludedPrincipals;
        return this;
    }

    public List<String> excludedActions() {
        return this.excludedActions;
    }

    public DenySettings withExcludedActions(List<String> excludedActions) {
        this.excludedActions = excludedActions;
        return this;
    }

    public Boolean applyToChildScopes() {
        return this.applyToChildScopes;
    }

    public DenySettings withApplyToChildScopes(Boolean applyToChildScopes) {
        this.applyToChildScopes = applyToChildScopes;
        return this;
    }

    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model DenySettings"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeArrayField("excludedPrincipals", this.excludedPrincipals, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludedActions", this.excludedActions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("applyToChildScopes", this.applyToChildScopes);
        return jsonWriter.writeEndObject();
    }

    public static DenySettings fromJson(JsonReader jsonReader) throws IOException {
        return (DenySettings)jsonReader.readObject(reader -> {
            DenySettings deserializedDenySettings = new DenySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedDenySettings.mode = DenySettingsMode.fromString(reader.getString());
                    continue;
                }
                if ("excludedPrincipals".equals(fieldName)) {
                    List excludedPrincipals;
                    deserializedDenySettings.excludedPrincipals = excludedPrincipals = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludedActions".equals(fieldName)) {
                    List excludedActions;
                    deserializedDenySettings.excludedActions = excludedActions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("applyToChildScopes".equals(fieldName)) {
                    deserializedDenySettings.applyToChildScopes = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDenySettings;
        });
    }
}

