/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.implementation.ChangesManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={ChangesManagementClientImpl.class})
public final class ChangesManagementClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public ChangesManagementClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public ChangesManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ChangesManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public ChangesManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public ChangesManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public ChangesManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public ChangesManagementClientImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://management.azure.com";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        ChangesManagementClientImpl client = new ChangesManagementClientImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.subscriptionId, this.endpoint);
        return client;
    }
}

