/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.dag;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.dag.DAGraph;
import com.azure.resourcemanager.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.IndexableTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskCancelledException;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroupEntry;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroupTerminateOnErrorStrategy;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.VoidIndexable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class TaskGroup
extends DAGraph<TaskItem, TaskGroupEntry<TaskItem>>
implements Indexable {
    private final TaskGroupEntry<TaskItem> rootTaskEntry;
    private TaskGroupTerminateOnErrorStrategy taskGroupTerminateOnErrorStrategy;
    private final AtomicBoolean isGroupCancelled;
    private final TaskCancelledException taskCancelledException = new TaskCancelledException();
    protected ProxyTaskGroupWrapper proxyTaskGroupWrapper;
    private final ClientLogger logger = new ClientLogger(this.getClass());

    private TaskGroup(TaskGroupEntry<TaskItem> rootTaskEntry) {
        super(rootTaskEntry);
        this.isGroupCancelled = new AtomicBoolean(false);
        this.rootTaskEntry = rootTaskEntry;
        this.proxyTaskGroupWrapper = new ProxyTaskGroupWrapper(this);
    }

    public TaskGroup(String rootTaskItemId, TaskItem rootTaskItem) {
        this(new TaskGroupEntry<TaskItem>(rootTaskItemId, rootTaskItem));
    }

    public TaskGroup(IndexableTaskItem rootTaskItem) {
        this(new TaskGroupEntry<TaskItem>(rootTaskItem.key(), rootTaskItem));
    }

    @Override
    public String key() {
        return this.rootTaskEntry.key();
    }

    public Indexable taskResult(String taskId) {
        TaskGroupEntry taskGroupEntry = (TaskGroupEntry)super.getNode(taskId);
        if (taskGroupEntry != null) {
            return taskGroupEntry.taskResult();
        }
        if (!this.proxyTaskGroupWrapper.isActive()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A dependency task with id '" + taskId + "' is not found"));
        }
        taskGroupEntry = (TaskGroupEntry)this.proxyTaskGroupWrapper.proxyTaskGroup.getNode(taskId);
        if (taskGroupEntry != null) {
            return taskGroupEntry.taskResult();
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A dependency task or 'post-run' dependent task with with id '" + taskId + "' not found"));
    }

    public boolean dependsOn(TaskGroup taskGroup) {
        return this.nodeTable.containsKey(taskGroup.root().key());
    }

    @Override
    protected TaskGroupEntry<TaskItem> root() {
        return this.rootTaskEntry;
    }

    public String addDependency(FunctionalTaskItem dependencyTaskItem) {
        IndexableTaskItem dependency = IndexableTaskItem.create(dependencyTaskItem);
        this.addDependency(dependency);
        return dependency.key();
    }

    public void addDependency(HasTaskGroup hasTaskGroup) {
        this.addDependencyTaskGroup(hasTaskGroup.taskGroup());
    }

    public void addDependencyTaskGroup(TaskGroup dependencyTaskGroup) {
        if (dependencyTaskGroup.proxyTaskGroupWrapper.isActive()) {
            dependencyTaskGroup.proxyTaskGroupWrapper.addDependentTaskGroup(this);
        } else {
            TaskGroup dependencyGraph = dependencyTaskGroup;
            super.addDependencyGraph(dependencyGraph);
        }
    }

    public String addPostRunDependent(FunctionalTaskItem dependentTaskItem) {
        IndexableTaskItem taskItem = IndexableTaskItem.create(dependentTaskItem);
        this.addPostRunDependent(taskItem);
        return taskItem.key();
    }

    public String addPostRunDependent(FunctionalTaskItem dependentTaskItem, ResourceManagerUtils.InternalRuntimeContext internalContext) {
        IndexableTaskItem taskItem = IndexableTaskItem.create(dependentTaskItem, internalContext);
        this.addPostRunDependent(taskItem);
        return taskItem.key();
    }

    public void addPostRunDependent(HasTaskGroup hasTaskGroup) {
        this.addPostRunDependentTaskGroup(hasTaskGroup.taskGroup());
    }

    public void addPostRunDependentTaskGroup(TaskGroup dependentTaskGroup) {
        this.proxyTaskGroupWrapper.addPostRunTaskGroupForActualTaskGroup(dependentTaskGroup);
    }

    public Flux<Indexable> invokeAsync(InvocationContext context) {
        return Flux.defer(() -> {
            if (this.proxyTaskGroupWrapper.isActive()) {
                return this.proxyTaskGroupWrapper.taskGroup().invokeInternAsync(context, true, null);
            }
            Set<String> processedKeys = this.runBeforeGroupInvoke(null);
            if (this.proxyTaskGroupWrapper.isActive()) {
                return this.proxyTaskGroupWrapper.taskGroup().invokeInternAsync(context, true, processedKeys);
            }
            return this.invokeInternAsync(context, false, null);
        });
    }

    public Mono<Indexable> invokeAsync() {
        return this.invokeAsync(this.newInvocationContext()).then(Mono.defer(() -> {
            if (this.proxyTaskGroupWrapper.isActive()) {
                return Mono.just((Object)((TaskGroupEntry)this.proxyTaskGroupWrapper.taskGroup().root()).taskResult());
            }
            return Mono.just((Object)((TaskGroupEntry)this.root()).taskResult());
        }));
    }

    public Flux<Indexable> invokeDependencyAsync(InvocationContext context) {
        String postRunErrorMessage = "Resource configuration which includes 'after create/update' operation is not supported.";
        context.put("SKIP_TASKS", Collections.singleton(this.key()));
        return Flux.defer(() -> {
            if (this.proxyTaskGroupWrapper.isActive()) {
                return Flux.error((Throwable)new IllegalStateException("Resource configuration which includes 'after create/update' operation is not supported."));
            }
            Set<String> processedKeys = this.runBeforeGroupInvoke(null);
            if (this.proxyTaskGroupWrapper.isActive()) {
                return Flux.error((Throwable)new IllegalStateException("Resource configuration which includes 'after create/update' operation is not supported."));
            }
            return this.invokeInternAsync(context, false, null);
        });
    }

    private Flux<Indexable> invokeInternAsync(InvocationContext context, boolean shouldRunBeforeGroupInvoke, Set<String> skipBeforeGroupInvoke) {
        if (!this.isPreparer()) {
            return Flux.error((Throwable)new IllegalStateException("invokeInternAsync(cxt) can be called only from root TaskGroup"));
        }
        this.taskGroupTerminateOnErrorStrategy = context.terminateOnErrorStrategy();
        if (shouldRunBeforeGroupInvoke) {
            this.runBeforeGroupInvoke(skipBeforeGroupInvoke);
        }
        return this.invokeReadyTasksAsync(context);
    }

    private Set<String> runBeforeGroupInvoke(Set<String> skip) {
        boolean hasMoreToProcess;
        HashSet<String> processedEntryKeys = new HashSet<String>();
        if (skip != null) {
            processedEntryKeys.addAll(skip);
        }
        List<TaskGroupEntry<TaskItem>> entries = this.entriesSnapshot();
        do {
            hasMoreToProcess = false;
            for (TaskGroupEntry<TaskItem> entry : entries) {
                if (processedEntryKeys.contains(entry.key())) continue;
                ((TaskItem)entry.data()).beforeGroupInvoke();
                processedEntryKeys.add(entry.key());
            }
            int prevSize = entries.size();
            entries = this.entriesSnapshot();
            if (entries.size() <= prevSize) continue;
            hasMoreToProcess = true;
        } while (hasMoreToProcess);
        super.prepareForEnumeration();
        return processedEntryKeys;
    }

    private List<TaskGroupEntry<TaskItem>> entriesSnapshot() {
        ArrayList<TaskGroupEntry<TaskItem>> entries = new ArrayList<TaskGroupEntry<TaskItem>>();
        super.prepareForEnumeration();
        TaskGroupEntry current = (TaskGroupEntry)super.getNext();
        while (current != null) {
            entries.add(current);
            super.reportCompletion(current);
            current = (TaskGroupEntry)super.getNext();
        }
        return entries;
    }

    private Flux<Indexable> invokeReadyTasksAsync(InvocationContext context) {
        TaskGroupEntry readyTaskEntry = (TaskGroupEntry)super.getNext();
        ArrayList<Flux<Indexable>> observables = new ArrayList<Flux<Indexable>>();
        while (readyTaskEntry != null) {
            TaskGroupEntry currentEntry = readyTaskEntry;
            TaskItem currentTaskItem = (TaskItem)currentEntry.data();
            if (currentTaskItem instanceof ProxyTaskItem) {
                observables.add(this.invokeAfterPostRunAsync(currentEntry, context));
            } else {
                observables.add(this.invokeTaskAsync(currentEntry, context));
            }
            readyTaskEntry = (TaskGroupEntry)super.getNext();
        }
        return Flux.mergeDelayError((int)32, (Publisher[])((Publisher[])observables.toArray(new Flux[0])));
    }

    private Flux<Indexable> invokeTaskAsync(TaskGroupEntry<TaskItem> entry, InvocationContext context) {
        return Flux.defer(() -> {
            if (this.isGroupCancelled.get()) {
                return this.processFaultedTaskAsync(entry, this.taskCancelledException, context);
            }
            boolean ignoreCachedResult = this.isRootEntry(entry) || entry.proxy() != null && this.isRootEntry(entry.proxy());
            Object skipTasks = context.get("SKIP_TASKS");
            Mono taskObservable = skipTasks instanceof Set && ((Set)skipTasks).contains(entry.key()) ? Mono.just((Object)new VoidIndexable(entry.key())) : entry.invokeTaskAsync(ignoreCachedResult, context);
            return taskObservable.flatMapMany(indexable -> Flux.just((Object)indexable), throwable -> this.processFaultedTaskAsync(entry, (Throwable)throwable, context), () -> this.processCompletedTaskAsync(entry, context));
        });
    }

    private Flux<Indexable> invokeAfterPostRunAsync(TaskGroupEntry<TaskItem> entry, InvocationContext context) {
        return Flux.defer(() -> {
            ProxyTaskItem proxyTaskItem = (ProxyTaskItem)entry.data();
            if (proxyTaskItem == null) {
                return Flux.empty();
            }
            boolean isFaulted = entry.hasFaultedDescentDependencyTasks() || this.isGroupCancelled.get();
            return proxyTaskItem.invokeAfterPostRunAsync(isFaulted).flatMapMany(indexable -> Flux.error((Throwable)new IllegalStateException("This onNext should never be called")), error -> this.processFaultedTaskAsync(entry, (Throwable)error, context), () -> {
                if (isFaulted) {
                    if (entry.hasFaultedDescentDependencyTasks()) {
                        return this.processFaultedTaskAsync(entry, new ErroredDependencyTaskException(), context);
                    }
                    return this.processFaultedTaskAsync(entry, this.taskCancelledException, context);
                }
                return Flux.concat((Publisher[])new Publisher[]{Flux.just((Object)proxyTaskItem.result()), this.processCompletedTaskAsync(entry, context)});
            });
        });
    }

    private Flux<Indexable> processCompletedTaskAsync(TaskGroupEntry<TaskItem> completedEntry, InvocationContext context) {
        this.reportCompletion(completedEntry);
        if (this.isRootEntry(completedEntry)) {
            return Flux.empty();
        }
        return this.invokeReadyTasksAsync(context);
    }

    private Flux<Indexable> processFaultedTaskAsync(TaskGroupEntry<TaskItem> faultedEntry, Throwable throwable, InvocationContext context) {
        this.markGroupAsCancelledIfTerminationStrategyIsIPTC();
        this.reportError(faultedEntry, throwable);
        if (this.isRootEntry(faultedEntry)) {
            if (TaskGroup.shouldPropagateException(throwable)) {
                return this.toErrorObservable(throwable);
            }
            return Flux.empty();
        }
        if (TaskGroup.shouldPropagateException(throwable)) {
            return Flux.concatDelayError((Publisher[])new Publisher[]{this.invokeReadyTasksAsync(context), this.toErrorObservable(throwable)});
        }
        return this.invokeReadyTasksAsync(context);
    }

    private void markGroupAsCancelledIfTerminationStrategyIsIPTC() {
        this.isGroupCancelled.set(this.taskGroupTerminateOnErrorStrategy == TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_IN_PROGRESS_TASKS_COMPLETION);
    }

    private boolean isRootEntry(TaskGroupEntry<TaskItem> taskGroupEntry) {
        return this.isRootNode(taskGroupEntry);
    }

    private static boolean shouldPropagateException(Throwable throwable) {
        return !(throwable instanceof ErroredDependencyTaskException) && !(throwable instanceof TaskCancelledException);
    }

    private Flux<Indexable> toErrorObservable(Throwable throwable) {
        return Flux.error((Throwable)throwable);
    }

    public InvocationContext newInvocationContext() {
        return new InvocationContext(this);
    }

    private static final class ProxyTaskItem
    implements TaskItem {
        private final TaskItem actualTaskItem;

        private ProxyTaskItem(TaskItem actualTaskItem) {
            this.actualTaskItem = actualTaskItem;
        }

        @Override
        public Indexable result() {
            return this.actualTaskItem.result();
        }

        @Override
        public void beforeGroupInvoke() {
        }

        @Override
        public boolean isHot() {
            return this.actualTaskItem.isHot();
        }

        @Override
        public Mono<Indexable> invokeAsync(InvocationContext context) {
            return Mono.just((Object)this.actualTaskItem.result());
        }

        @Override
        public Mono<Void> invokeAfterPostRunAsync(boolean isGroupFaulted) {
            if (this.actualTaskItem.isHot()) {
                return Mono.defer(() -> this.actualTaskItem.invokeAfterPostRunAsync(isGroupFaulted).subscribeOn(Schedulers.immediate()));
            }
            return this.actualTaskItem.invokeAfterPostRunAsync(isGroupFaulted).subscribeOn(Schedulers.immediate());
        }
    }

    protected static final class ProxyTaskGroupWrapper {
        private TaskGroup proxyTaskGroup;
        private final TaskGroup actualTaskGroup;
        private final ClientLogger logger = new ClientLogger(this.getClass());

        ProxyTaskGroupWrapper(TaskGroup actualTaskGroup) {
            this.actualTaskGroup = actualTaskGroup;
        }

        boolean isActive() {
            return this.proxyTaskGroup != null;
        }

        TaskGroup taskGroup() {
            return this.proxyTaskGroup;
        }

        void addPostRunTaskGroupForActualTaskGroup(TaskGroup postRunTaskGroup) {
            if (this.proxyTaskGroup == null) {
                this.initProxyTaskGroup();
            }
            postRunTaskGroup.addDependencyGraph(this.actualTaskGroup);
            if (postRunTaskGroup.proxyTaskGroupWrapper.isActive()) {
                this.proxyTaskGroup.addDependencyGraph(postRunTaskGroup.proxyTaskGroupWrapper.proxyTaskGroup);
            } else {
                this.proxyTaskGroup.addDependencyGraph(postRunTaskGroup);
            }
        }

        void addDependentTaskGroup(TaskGroup dependentTaskGroup) {
            if (this.proxyTaskGroup == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("addDependentTaskGroup() cannot be called in a non-active ProxyTaskGroup"));
            }
            dependentTaskGroup.addDependencyGraph(this.proxyTaskGroup);
        }

        private void initProxyTaskGroup() {
            if (this.proxyTaskGroup == null) {
                ProxyTaskItem proxyTaskItem = new ProxyTaskItem((TaskItem)this.actualTaskGroup.root().data());
                this.proxyTaskGroup = new TaskGroup("proxy-" + this.actualTaskGroup.root().key(), proxyTaskItem);
                if (this.actualTaskGroup.hasParents()) {
                    String atgRootKey = this.actualTaskGroup.root().key();
                    for (DAGraph parentDAG : this.actualTaskGroup.parentDAGs) {
                        ((TaskGroupEntry)parentDAG.root()).removeDependency(atgRootKey);
                        parentDAG.addDependencyGraph(this.proxyTaskGroup);
                    }
                    this.actualTaskGroup.parentDAGs.clear();
                }
                this.proxyTaskGroup.addDependencyGraph(this.actualTaskGroup);
                this.actualTaskGroup.rootTaskEntry.setProxy(this.proxyTaskGroup.rootTaskEntry);
            }
        }
    }

    public static final class InvocationContext {
        public static final String KEY_SKIP_TASKS = "SKIP_TASKS";
        private final Map<String, Object> properties;
        private final TaskGroup taskGroup;
        private TaskGroupTerminateOnErrorStrategy terminateOnErrorStrategy;
        private final ClientLogger logger = new ClientLogger(this.getClass());

        private InvocationContext(TaskGroup taskGroup) {
            this.properties = new ConcurrentHashMap<String, Object>();
            this.taskGroup = taskGroup;
        }

        public TaskGroup taskGroup() {
            return this.taskGroup;
        }

        public InvocationContext withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy strategy) {
            if (this.terminateOnErrorStrategy != null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Termination strategy is already set, it is immutable for a specific context"));
            }
            this.terminateOnErrorStrategy = strategy;
            return this;
        }

        public TaskGroupTerminateOnErrorStrategy terminateOnErrorStrategy() {
            if (this.terminateOnErrorStrategy == null) {
                return TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_HITTING_LCA_TASK;
            }
            return this.terminateOnErrorStrategy;
        }

        public void put(String key, Object value) {
            this.properties.put(key, value);
        }

        public Object get(String key) {
            return this.properties.get(key);
        }

        public boolean hasKey(String key) {
            return this.get(key) != null;
        }
    }

    public static interface HasTaskGroup {
        public TaskGroup taskGroup();
    }
}

