// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.privatedns.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.privatedns.models.AaaaRecord;
import com.azure.resourcemanager.privatedns.models.ARecord;
import com.azure.resourcemanager.privatedns.models.CnameRecord;
import com.azure.resourcemanager.privatedns.models.MxRecord;
import com.azure.resourcemanager.privatedns.models.PtrRecord;
import com.azure.resourcemanager.privatedns.models.SoaRecord;
import com.azure.resourcemanager.privatedns.models.SrvRecord;
import com.azure.resourcemanager.privatedns.models.TxtRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Represents the properties of the records in the record set.
 */
@Fluent
public final class RecordSetProperties implements JsonSerializable<RecordSetProperties> {
    /*
     * The metadata attached to the record set.
     */
    private Map<String, String> metadata;

    /*
     * The TTL (time-to-live) of the records in the record set.
     */
    private Long ttl;

    /*
     * Fully qualified domain name of the record set.
     */
    private String fqdn;

    /*
     * Is the record set auto-registered in the Private DNS zone through a virtual network link?
     */
    private Boolean isAutoRegistered;

    /*
     * The list of A records in the record set.
     */
    private List<ARecord> aRecords;

    /*
     * The list of AAAA records in the record set.
     */
    private List<AaaaRecord> aaaaRecords;

    /*
     * The CNAME record in the record set.
     */
    private CnameRecord cnameRecord;

    /*
     * The list of MX records in the record set.
     */
    private List<MxRecord> mxRecords;

    /*
     * The list of PTR records in the record set.
     */
    private List<PtrRecord> ptrRecords;

    /*
     * The SOA record in the record set.
     */
    private SoaRecord soaRecord;

    /*
     * The list of SRV records in the record set.
     */
    private List<SrvRecord> srvRecords;

    /*
     * The list of TXT records in the record set.
     */
    private List<TxtRecord> txtRecords;

    /**
     * Creates an instance of RecordSetProperties class.
     */
    public RecordSetProperties() {
    }

    /**
     * Get the metadata property: The metadata attached to the record set.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The metadata attached to the record set.
     * 
     * @param metadata the metadata value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the ttl property: The TTL (time-to-live) of the records in the record set.
     * 
     * @return the ttl value.
     */
    public Long ttl() {
        return this.ttl;
    }

    /**
     * Set the ttl property: The TTL (time-to-live) of the records in the record set.
     * 
     * @param ttl the ttl value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withTtl(Long ttl) {
        this.ttl = ttl;
        return this;
    }

    /**
     * Get the fqdn property: Fully qualified domain name of the record set.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the isAutoRegistered property: Is the record set auto-registered in the Private DNS zone through a virtual
     * network link?.
     * 
     * @return the isAutoRegistered value.
     */
    public Boolean isAutoRegistered() {
        return this.isAutoRegistered;
    }

    /**
     * Get the aRecords property: The list of A records in the record set.
     * 
     * @return the aRecords value.
     */
    public List<ARecord> aRecords() {
        return this.aRecords;
    }

    /**
     * Set the aRecords property: The list of A records in the record set.
     * 
     * @param aRecords the aRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withARecords(List<ARecord> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    /**
     * Get the aaaaRecords property: The list of AAAA records in the record set.
     * 
     * @return the aaaaRecords value.
     */
    public List<AaaaRecord> aaaaRecords() {
        return this.aaaaRecords;
    }

    /**
     * Set the aaaaRecords property: The list of AAAA records in the record set.
     * 
     * @param aaaaRecords the aaaaRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withAaaaRecords(List<AaaaRecord> aaaaRecords) {
        this.aaaaRecords = aaaaRecords;
        return this;
    }

    /**
     * Get the cnameRecord property: The CNAME record in the record set.
     * 
     * @return the cnameRecord value.
     */
    public CnameRecord cnameRecord() {
        return this.cnameRecord;
    }

    /**
     * Set the cnameRecord property: The CNAME record in the record set.
     * 
     * @param cnameRecord the cnameRecord value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withCnameRecord(CnameRecord cnameRecord) {
        this.cnameRecord = cnameRecord;
        return this;
    }

    /**
     * Get the mxRecords property: The list of MX records in the record set.
     * 
     * @return the mxRecords value.
     */
    public List<MxRecord> mxRecords() {
        return this.mxRecords;
    }

    /**
     * Set the mxRecords property: The list of MX records in the record set.
     * 
     * @param mxRecords the mxRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withMxRecords(List<MxRecord> mxRecords) {
        this.mxRecords = mxRecords;
        return this;
    }

    /**
     * Get the ptrRecords property: The list of PTR records in the record set.
     * 
     * @return the ptrRecords value.
     */
    public List<PtrRecord> ptrRecords() {
        return this.ptrRecords;
    }

    /**
     * Set the ptrRecords property: The list of PTR records in the record set.
     * 
     * @param ptrRecords the ptrRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withPtrRecords(List<PtrRecord> ptrRecords) {
        this.ptrRecords = ptrRecords;
        return this;
    }

    /**
     * Get the soaRecord property: The SOA record in the record set.
     * 
     * @return the soaRecord value.
     */
    public SoaRecord soaRecord() {
        return this.soaRecord;
    }

    /**
     * Set the soaRecord property: The SOA record in the record set.
     * 
     * @param soaRecord the soaRecord value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withSoaRecord(SoaRecord soaRecord) {
        this.soaRecord = soaRecord;
        return this;
    }

    /**
     * Get the srvRecords property: The list of SRV records in the record set.
     * 
     * @return the srvRecords value.
     */
    public List<SrvRecord> srvRecords() {
        return this.srvRecords;
    }

    /**
     * Set the srvRecords property: The list of SRV records in the record set.
     * 
     * @param srvRecords the srvRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withSrvRecords(List<SrvRecord> srvRecords) {
        this.srvRecords = srvRecords;
        return this;
    }

    /**
     * Get the txtRecords property: The list of TXT records in the record set.
     * 
     * @return the txtRecords value.
     */
    public List<TxtRecord> txtRecords() {
        return this.txtRecords;
    }

    /**
     * Set the txtRecords property: The list of TXT records in the record set.
     * 
     * @param txtRecords the txtRecords value to set.
     * @return the RecordSetProperties object itself.
     */
    public RecordSetProperties withTxtRecords(List<TxtRecord> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (aRecords() != null) {
            aRecords().forEach(e -> e.validate());
        }
        if (aaaaRecords() != null) {
            aaaaRecords().forEach(e -> e.validate());
        }
        if (cnameRecord() != null) {
            cnameRecord().validate();
        }
        if (mxRecords() != null) {
            mxRecords().forEach(e -> e.validate());
        }
        if (ptrRecords() != null) {
            ptrRecords().forEach(e -> e.validate());
        }
        if (soaRecord() != null) {
            soaRecord().validate();
        }
        if (srvRecords() != null) {
            srvRecords().forEach(e -> e.validate());
        }
        if (txtRecords() != null) {
            txtRecords().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("ttl", this.ttl);
        jsonWriter.writeArrayField("aRecords", this.aRecords, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("aaaaRecords", this.aaaaRecords, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("cnameRecord", this.cnameRecord);
        jsonWriter.writeArrayField("mxRecords", this.mxRecords, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ptrRecords", this.ptrRecords, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("soaRecord", this.soaRecord);
        jsonWriter.writeArrayField("srvRecords", this.srvRecords, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("txtRecords", this.txtRecords, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecordSetProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecordSetProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecordSetProperties.
     */
    public static RecordSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordSetProperties deserializedRecordSetProperties = new RecordSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedRecordSetProperties.metadata = metadata;
                } else if ("ttl".equals(fieldName)) {
                    deserializedRecordSetProperties.ttl = reader.getNullable(JsonReader::getLong);
                } else if ("fqdn".equals(fieldName)) {
                    deserializedRecordSetProperties.fqdn = reader.getString();
                } else if ("isAutoRegistered".equals(fieldName)) {
                    deserializedRecordSetProperties.isAutoRegistered = reader.getNullable(JsonReader::getBoolean);
                } else if ("aRecords".equals(fieldName)) {
                    List<ARecord> aRecords = reader.readArray(reader1 -> ARecord.fromJson(reader1));
                    deserializedRecordSetProperties.aRecords = aRecords;
                } else if ("aaaaRecords".equals(fieldName)) {
                    List<AaaaRecord> aaaaRecords = reader.readArray(reader1 -> AaaaRecord.fromJson(reader1));
                    deserializedRecordSetProperties.aaaaRecords = aaaaRecords;
                } else if ("cnameRecord".equals(fieldName)) {
                    deserializedRecordSetProperties.cnameRecord = CnameRecord.fromJson(reader);
                } else if ("mxRecords".equals(fieldName)) {
                    List<MxRecord> mxRecords = reader.readArray(reader1 -> MxRecord.fromJson(reader1));
                    deserializedRecordSetProperties.mxRecords = mxRecords;
                } else if ("ptrRecords".equals(fieldName)) {
                    List<PtrRecord> ptrRecords = reader.readArray(reader1 -> PtrRecord.fromJson(reader1));
                    deserializedRecordSetProperties.ptrRecords = ptrRecords;
                } else if ("soaRecord".equals(fieldName)) {
                    deserializedRecordSetProperties.soaRecord = SoaRecord.fromJson(reader);
                } else if ("srvRecords".equals(fieldName)) {
                    List<SrvRecord> srvRecords = reader.readArray(reader1 -> SrvRecord.fromJson(reader1));
                    deserializedRecordSetProperties.srvRecords = srvRecords;
                } else if ("txtRecords".equals(fieldName)) {
                    List<TxtRecord> txtRecords = reader.readArray(reader1 -> TxtRecord.fromJson(reader1));
                    deserializedRecordSetProperties.txtRecords = txtRecords;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecordSetProperties;
        });
    }
}
