/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Action;
import com.azure.resourcemanager.network.models.Criterion;
import com.azure.resourcemanager.network.models.NextStep;
import java.io.IOException;
import java.util.List;

public final class RouteMapRule
implements JsonSerializable<RouteMapRule> {
    private String name;
    private List<Criterion> matchCriteria;
    private List<Action> actions;
    private NextStep nextStepIfMatched;

    public String name() {
        return this.name;
    }

    public RouteMapRule withName(String name) {
        this.name = name;
        return this;
    }

    public List<Criterion> matchCriteria() {
        return this.matchCriteria;
    }

    public RouteMapRule withMatchCriteria(List<Criterion> matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public RouteMapRule withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public NextStep nextStepIfMatched() {
        return this.nextStepIfMatched;
    }

    public RouteMapRule withNextStepIfMatched(NextStep nextStepIfMatched) {
        this.nextStepIfMatched = nextStepIfMatched;
        return this;
    }

    public void validate() {
        if (this.matchCriteria() != null) {
            this.matchCriteria().forEach(e -> e.validate());
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("matchCriteria", this.matchCriteria, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextStepIfMatched", this.nextStepIfMatched == null ? null : this.nextStepIfMatched.toString());
        return jsonWriter.writeEndObject();
    }

    public static RouteMapRule fromJson(JsonReader jsonReader) throws IOException {
        return (RouteMapRule)jsonReader.readObject(reader -> {
            RouteMapRule deserializedRouteMapRule = new RouteMapRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRouteMapRule.name = reader.getString();
                    continue;
                }
                if ("matchCriteria".equals(fieldName)) {
                    List matchCriteria;
                    deserializedRouteMapRule.matchCriteria = matchCriteria = reader.readArray(reader1 -> Criterion.fromJson(reader1));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedRouteMapRule.actions = actions = reader.readArray(reader1 -> Action.fromJson(reader1));
                    continue;
                }
                if ("nextStepIfMatched".equals(fieldName)) {
                    deserializedRouteMapRule.nextStepIfMatched = NextStep.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteMapRule;
        });
    }
}

