/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpGroupInner;
import java.io.IOException;
import java.util.List;

public final class IpGroupListResult
implements JsonSerializable<IpGroupListResult> {
    private List<IpGroupInner> value;
    private String nextLink;

    public List<IpGroupInner> value() {
        return this.value;
    }

    public IpGroupListResult withValue(List<IpGroupInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public IpGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static IpGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (IpGroupListResult)jsonReader.readObject(reader -> {
            IpGroupListResult deserializedIpGroupListResult = new IpGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedIpGroupListResult.value = value = reader.readArray(reader1 -> IpGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedIpGroupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpGroupListResult;
        });
    }
}

