/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkInner;
import com.azure.resourcemanager.network.fluent.models.VpnSiteProperties;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.DeviceProperties;
import com.azure.resourcemanager.network.models.O365PolicyProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VpnSiteInner
extends Resource {
    private VpnSiteProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VpnSiteProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VpnSiteInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VpnSiteInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VpnSiteInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualWan() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualWan();
    }

    public VpnSiteInner withVirtualWan(SubResource virtualWan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withVirtualWan(virtualWan);
        return this;
    }

    public DeviceProperties deviceProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().deviceProperties();
    }

    public VpnSiteInner withDeviceProperties(DeviceProperties deviceProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withDeviceProperties(deviceProperties);
        return this;
    }

    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public VpnSiteInner withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public String siteKey() {
        return this.innerProperties() == null ? null : this.innerProperties().siteKey();
    }

    public VpnSiteInner withSiteKey(String siteKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withSiteKey(siteKey);
        return this;
    }

    public AddressSpace addressSpace() {
        return this.innerProperties() == null ? null : this.innerProperties().addressSpace();
    }

    public VpnSiteInner withAddressSpace(AddressSpace addressSpace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withAddressSpace(addressSpace);
        return this;
    }

    public BgpSettings bgpProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpProperties();
    }

    public VpnSiteInner withBgpProperties(BgpSettings bgpProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withBgpProperties(bgpProperties);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean isSecuritySite() {
        return this.innerProperties() == null ? null : this.innerProperties().isSecuritySite();
    }

    public VpnSiteInner withIsSecuritySite(Boolean isSecuritySite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withIsSecuritySite(isSecuritySite);
        return this;
    }

    public List<VpnSiteLinkInner> vpnSiteLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSiteLinks();
    }

    public VpnSiteInner withVpnSiteLinks(List<VpnSiteLinkInner> vpnSiteLinks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withVpnSiteLinks(vpnSiteLinks);
        return this;
    }

    public O365PolicyProperties o365Policy() {
        return this.innerProperties() == null ? null : this.innerProperties().o365Policy();
    }

    public VpnSiteInner withO365Policy(O365PolicyProperties o365Policy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteProperties();
        }
        this.innerProperties().withO365Policy(o365Policy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VpnSiteInner fromJson(JsonReader jsonReader) throws IOException {
        return (VpnSiteInner)((Object)jsonReader.readObject(reader -> {
            VpnSiteInner deserializedVpnSiteInner = new VpnSiteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVpnSiteInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVpnSiteInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVpnSiteInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVpnSiteInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVpnSiteInner.innerProperties = VpnSiteProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnSiteInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVpnSiteInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnSiteInner;
        }));
    }
}

