/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NatGatewayInner;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ReferencedPublicIpAddress;
import java.io.IOException;
import java.util.List;

public final class PublicIpPrefixPropertiesFormatInner
implements JsonSerializable<PublicIpPrefixPropertiesFormatInner> {
    private IpVersion publicIpAddressVersion;
    private List<IpTag> ipTags;
    private Integer prefixLength;
    private String ipPrefix;
    private List<ReferencedPublicIpAddress> publicIpAddresses;
    private SubResource loadBalancerFrontendIpConfiguration;
    private SubResource customIpPrefix;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private NatGatewayInner natGateway;

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public PublicIpPrefixPropertiesFormatInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public List<IpTag> ipTags() {
        return this.ipTags;
    }

    public PublicIpPrefixPropertiesFormatInner withIpTags(List<IpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public Integer prefixLength() {
        return this.prefixLength;
    }

    public PublicIpPrefixPropertiesFormatInner withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public String ipPrefix() {
        return this.ipPrefix;
    }

    public List<ReferencedPublicIpAddress> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.loadBalancerFrontendIpConfiguration;
    }

    public SubResource customIpPrefix() {
        return this.customIpPrefix;
    }

    public PublicIpPrefixPropertiesFormatInner withCustomIpPrefix(SubResource customIpPrefix) {
        this.customIpPrefix = customIpPrefix;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NatGatewayInner natGateway() {
        return this.natGateway;
    }

    public PublicIpPrefixPropertiesFormatInner withNatGateway(NatGatewayInner natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    public void validate() {
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
        if (this.publicIpAddresses() != null) {
            this.publicIpAddresses().forEach(e -> e.validate());
        }
        if (this.natGateway() != null) {
            this.natGateway().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicIPAddressVersion", this.publicIpAddressVersion == null ? null : this.publicIpAddressVersion.toString());
        jsonWriter.writeArrayField("ipTags", this.ipTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("prefixLength", (Number)this.prefixLength);
        jsonWriter.writeJsonField("customIPPrefix", (JsonSerializable)this.customIpPrefix);
        jsonWriter.writeJsonField("natGateway", (JsonSerializable)this.natGateway);
        return jsonWriter.writeEndObject();
    }

    public static PublicIpPrefixPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (PublicIpPrefixPropertiesFormatInner)jsonReader.readObject(reader -> {
            PublicIpPrefixPropertiesFormatInner deserializedPublicIpPrefixPropertiesFormatInner = new PublicIpPrefixPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicIPAddressVersion".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.publicIpAddressVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                if ("ipTags".equals(fieldName)) {
                    List ipTags;
                    deserializedPublicIpPrefixPropertiesFormatInner.ipTags = ipTags = reader.readArray(reader1 -> IpTag.fromJson(reader1));
                    continue;
                }
                if ("prefixLength".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.prefixLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ipPrefix".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.ipPrefix = reader.getString();
                    continue;
                }
                if ("publicIPAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedPublicIpPrefixPropertiesFormatInner.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> ReferencedPublicIpAddress.fromJson(reader1));
                    continue;
                }
                if ("loadBalancerFrontendIpConfiguration".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.loadBalancerFrontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("customIPPrefix".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.customIpPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("natGateway".equals(fieldName)) {
                    deserializedPublicIpPrefixPropertiesFormatInner.natGateway = NatGatewayInner.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicIpPrefixPropertiesFormatInner;
        });
    }
}

