/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitAuthorizationInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitServiceProviderProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteCircuitPropertiesFormat
implements JsonSerializable<ExpressRouteCircuitPropertiesFormat> {
    private Boolean allowClassicOperations;
    private String circuitProvisioningState;
    private ServiceProviderProvisioningState serviceProviderProvisioningState;
    private List<ExpressRouteCircuitAuthorizationInner> authorizations;
    private List<ExpressRouteCircuitPeeringInner> peerings;
    private String serviceKey;
    private String serviceProviderNotes;
    private ExpressRouteCircuitServiceProviderProperties serviceProviderProperties;
    private SubResource expressRoutePort;
    private Float bandwidthInGbps;
    private Integer stag;
    private ProvisioningState provisioningState;
    private String gatewayManagerEtag;
    private Boolean globalReachEnabled;
    private String authorizationKey;
    private String authorizationStatus;
    private Boolean enableDirectPortRateLimit;

    public Boolean allowClassicOperations() {
        return this.allowClassicOperations;
    }

    public ExpressRouteCircuitPropertiesFormat withAllowClassicOperations(Boolean allowClassicOperations) {
        this.allowClassicOperations = allowClassicOperations;
        return this;
    }

    public String circuitProvisioningState() {
        return this.circuitProvisioningState;
    }

    public ExpressRouteCircuitPropertiesFormat withCircuitProvisioningState(String circuitProvisioningState) {
        this.circuitProvisioningState = circuitProvisioningState;
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.serviceProviderProvisioningState;
    }

    public ExpressRouteCircuitPropertiesFormat withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        this.serviceProviderProvisioningState = serviceProviderProvisioningState;
        return this;
    }

    public List<ExpressRouteCircuitAuthorizationInner> authorizations() {
        return this.authorizations;
    }

    public ExpressRouteCircuitPropertiesFormat withAuthorizations(List<ExpressRouteCircuitAuthorizationInner> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.peerings;
    }

    public ExpressRouteCircuitPropertiesFormat withPeerings(List<ExpressRouteCircuitPeeringInner> peerings) {
        this.peerings = peerings;
        return this;
    }

    public String serviceKey() {
        return this.serviceKey;
    }

    public ExpressRouteCircuitPropertiesFormat withServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        return this;
    }

    public String serviceProviderNotes() {
        return this.serviceProviderNotes;
    }

    public ExpressRouteCircuitPropertiesFormat withServiceProviderNotes(String serviceProviderNotes) {
        this.serviceProviderNotes = serviceProviderNotes;
        return this;
    }

    public ExpressRouteCircuitServiceProviderProperties serviceProviderProperties() {
        return this.serviceProviderProperties;
    }

    public ExpressRouteCircuitPropertiesFormat withServiceProviderProperties(ExpressRouteCircuitServiceProviderProperties serviceProviderProperties) {
        this.serviceProviderProperties = serviceProviderProperties;
        return this;
    }

    public SubResource expressRoutePort() {
        return this.expressRoutePort;
    }

    public ExpressRouteCircuitPropertiesFormat withExpressRoutePort(SubResource expressRoutePort) {
        this.expressRoutePort = expressRoutePort;
        return this;
    }

    public Float bandwidthInGbps() {
        return this.bandwidthInGbps;
    }

    public ExpressRouteCircuitPropertiesFormat withBandwidthInGbps(Float bandwidthInGbps) {
        this.bandwidthInGbps = bandwidthInGbps;
        return this;
    }

    public Integer stag() {
        return this.stag;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String gatewayManagerEtag() {
        return this.gatewayManagerEtag;
    }

    public ExpressRouteCircuitPropertiesFormat withGatewayManagerEtag(String gatewayManagerEtag) {
        this.gatewayManagerEtag = gatewayManagerEtag;
        return this;
    }

    public Boolean globalReachEnabled() {
        return this.globalReachEnabled;
    }

    public ExpressRouteCircuitPropertiesFormat withGlobalReachEnabled(Boolean globalReachEnabled) {
        this.globalReachEnabled = globalReachEnabled;
        return this;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public ExpressRouteCircuitPropertiesFormat withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public String authorizationStatus() {
        return this.authorizationStatus;
    }

    public Boolean enableDirectPortRateLimit() {
        return this.enableDirectPortRateLimit;
    }

    public ExpressRouteCircuitPropertiesFormat withEnableDirectPortRateLimit(Boolean enableDirectPortRateLimit) {
        this.enableDirectPortRateLimit = enableDirectPortRateLimit;
        return this;
    }

    public void validate() {
        if (this.authorizations() != null) {
            this.authorizations().forEach(e -> e.validate());
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
        if (this.serviceProviderProperties() != null) {
            this.serviceProviderProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowClassicOperations", this.allowClassicOperations);
        jsonWriter.writeStringField("circuitProvisioningState", this.circuitProvisioningState);
        jsonWriter.writeStringField("serviceProviderProvisioningState", this.serviceProviderProvisioningState == null ? null : this.serviceProviderProvisioningState.toString());
        jsonWriter.writeArrayField("authorizations", this.authorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("peerings", this.peerings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serviceKey", this.serviceKey);
        jsonWriter.writeStringField("serviceProviderNotes", this.serviceProviderNotes);
        jsonWriter.writeJsonField("serviceProviderProperties", (JsonSerializable)this.serviceProviderProperties);
        jsonWriter.writeJsonField("expressRoutePort", (JsonSerializable)this.expressRoutePort);
        jsonWriter.writeNumberField("bandwidthInGbps", (Number)this.bandwidthInGbps);
        jsonWriter.writeStringField("gatewayManagerEtag", this.gatewayManagerEtag);
        jsonWriter.writeBooleanField("globalReachEnabled", this.globalReachEnabled);
        jsonWriter.writeStringField("authorizationKey", this.authorizationKey);
        jsonWriter.writeBooleanField("enableDirectPortRateLimit", this.enableDirectPortRateLimit);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitPropertiesFormat)jsonReader.readObject(reader -> {
            ExpressRouteCircuitPropertiesFormat deserializedExpressRouteCircuitPropertiesFormat = new ExpressRouteCircuitPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowClassicOperations".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.allowClassicOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("circuitProvisioningState".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.circuitProvisioningState = reader.getString();
                    continue;
                }
                if ("serviceProviderProvisioningState".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.serviceProviderProvisioningState = ServiceProviderProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("authorizations".equals(fieldName)) {
                    List authorizations;
                    deserializedExpressRouteCircuitPropertiesFormat.authorizations = authorizations = reader.readArray(reader1 -> ExpressRouteCircuitAuthorizationInner.fromJson(reader1));
                    continue;
                }
                if ("peerings".equals(fieldName)) {
                    List peerings;
                    deserializedExpressRouteCircuitPropertiesFormat.peerings = peerings = reader.readArray(reader1 -> ExpressRouteCircuitPeeringInner.fromJson(reader1));
                    continue;
                }
                if ("serviceKey".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.serviceKey = reader.getString();
                    continue;
                }
                if ("serviceProviderNotes".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.serviceProviderNotes = reader.getString();
                    continue;
                }
                if ("serviceProviderProperties".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.serviceProviderProperties = ExpressRouteCircuitServiceProviderProperties.fromJson(reader);
                    continue;
                }
                if ("expressRoutePort".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.expressRoutePort = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("bandwidthInGbps".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.bandwidthInGbps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("stag".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.stag = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("gatewayManagerEtag".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.gatewayManagerEtag = reader.getString();
                    continue;
                }
                if ("globalReachEnabled".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.globalReachEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("authorizationKey".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.authorizationKey = reader.getString();
                    continue;
                }
                if ("authorizationStatus".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.authorizationStatus = reader.getString();
                    continue;
                }
                if ("enableDirectPortRateLimit".equals(fieldName)) {
                    deserializedExpressRouteCircuitPropertiesFormat.enableDirectPortRateLimit = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitPropertiesFormat;
        });
    }
}

