/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallAutoscaleConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpGroups;
import com.azure.resourcemanager.network.models.AzureFirewallNatRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallSku;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.HubIpAddresses;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AzureFirewallPropertiesFormat
implements JsonSerializable<AzureFirewallPropertiesFormat> {
    private List<AzureFirewallApplicationRuleCollection> applicationRuleCollections;
    private List<AzureFirewallNatRuleCollection> natRuleCollections;
    private List<AzureFirewallNetworkRuleCollection> networkRuleCollections;
    private List<AzureFirewallIpConfiguration> ipConfigurations;
    private AzureFirewallIpConfiguration managementIpConfiguration;
    private ProvisioningState provisioningState;
    private AzureFirewallThreatIntelMode threatIntelMode;
    private SubResource virtualHub;
    private SubResource firewallPolicy;
    private HubIpAddresses hubIpAddresses;
    private List<AzureFirewallIpGroups> ipGroups;
    private AzureFirewallSku sku;
    private Map<String, String> additionalProperties;
    private AzureFirewallAutoscaleConfiguration autoscaleConfiguration;

    public List<AzureFirewallApplicationRuleCollection> applicationRuleCollections() {
        return this.applicationRuleCollections;
    }

    public AzureFirewallPropertiesFormat withApplicationRuleCollections(List<AzureFirewallApplicationRuleCollection> applicationRuleCollections) {
        this.applicationRuleCollections = applicationRuleCollections;
        return this;
    }

    public List<AzureFirewallNatRuleCollection> natRuleCollections() {
        return this.natRuleCollections;
    }

    public AzureFirewallPropertiesFormat withNatRuleCollections(List<AzureFirewallNatRuleCollection> natRuleCollections) {
        this.natRuleCollections = natRuleCollections;
        return this;
    }

    public List<AzureFirewallNetworkRuleCollection> networkRuleCollections() {
        return this.networkRuleCollections;
    }

    public AzureFirewallPropertiesFormat withNetworkRuleCollections(List<AzureFirewallNetworkRuleCollection> networkRuleCollections) {
        this.networkRuleCollections = networkRuleCollections;
        return this;
    }

    public List<AzureFirewallIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public AzureFirewallPropertiesFormat withIpConfigurations(List<AzureFirewallIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public AzureFirewallIpConfiguration managementIpConfiguration() {
        return this.managementIpConfiguration;
    }

    public AzureFirewallPropertiesFormat withManagementIpConfiguration(AzureFirewallIpConfiguration managementIpConfiguration) {
        this.managementIpConfiguration = managementIpConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.threatIntelMode;
    }

    public AzureFirewallPropertiesFormat withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        this.threatIntelMode = threatIntelMode;
        return this;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public AzureFirewallPropertiesFormat withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public SubResource firewallPolicy() {
        return this.firewallPolicy;
    }

    public AzureFirewallPropertiesFormat withFirewallPolicy(SubResource firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        return this;
    }

    public HubIpAddresses hubIpAddresses() {
        return this.hubIpAddresses;
    }

    public AzureFirewallPropertiesFormat withHubIpAddresses(HubIpAddresses hubIpAddresses) {
        this.hubIpAddresses = hubIpAddresses;
        return this;
    }

    public List<AzureFirewallIpGroups> ipGroups() {
        return this.ipGroups;
    }

    public AzureFirewallSku sku() {
        return this.sku;
    }

    public AzureFirewallPropertiesFormat withSku(AzureFirewallSku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    public AzureFirewallPropertiesFormat withAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public AzureFirewallAutoscaleConfiguration autoscaleConfiguration() {
        return this.autoscaleConfiguration;
    }

    public AzureFirewallPropertiesFormat withAutoscaleConfiguration(AzureFirewallAutoscaleConfiguration autoscaleConfiguration) {
        this.autoscaleConfiguration = autoscaleConfiguration;
        return this;
    }

    public void validate() {
        if (this.applicationRuleCollections() != null) {
            this.applicationRuleCollections().forEach(e -> e.validate());
        }
        if (this.natRuleCollections() != null) {
            this.natRuleCollections().forEach(e -> e.validate());
        }
        if (this.networkRuleCollections() != null) {
            this.networkRuleCollections().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.managementIpConfiguration() != null) {
            this.managementIpConfiguration().validate();
        }
        if (this.hubIpAddresses() != null) {
            this.hubIpAddresses().validate();
        }
        if (this.ipGroups() != null) {
            this.ipGroups().forEach(e -> e.validate());
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.autoscaleConfiguration() != null) {
            this.autoscaleConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("applicationRuleCollections", this.applicationRuleCollections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("natRuleCollections", this.natRuleCollections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("networkRuleCollections", this.networkRuleCollections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("managementIpConfiguration", (JsonSerializable)this.managementIpConfiguration);
        jsonWriter.writeStringField("threatIntelMode", this.threatIntelMode == null ? null : this.threatIntelMode.toString());
        jsonWriter.writeJsonField("virtualHub", (JsonSerializable)this.virtualHub);
        jsonWriter.writeJsonField("firewallPolicy", (JsonSerializable)this.firewallPolicy);
        jsonWriter.writeJsonField("hubIPAddresses", (JsonSerializable)this.hubIpAddresses);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("additionalProperties", this.additionalProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("autoscaleConfiguration", (JsonSerializable)this.autoscaleConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallPropertiesFormat)jsonReader.readObject(reader -> {
            AzureFirewallPropertiesFormat deserializedAzureFirewallPropertiesFormat = new AzureFirewallPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("applicationRuleCollections".equals(fieldName)) {
                    List applicationRuleCollections;
                    deserializedAzureFirewallPropertiesFormat.applicationRuleCollections = applicationRuleCollections = reader.readArray(reader1 -> AzureFirewallApplicationRuleCollection.fromJson(reader1));
                    continue;
                }
                if ("natRuleCollections".equals(fieldName)) {
                    List natRuleCollections;
                    deserializedAzureFirewallPropertiesFormat.natRuleCollections = natRuleCollections = reader.readArray(reader1 -> AzureFirewallNatRuleCollection.fromJson(reader1));
                    continue;
                }
                if ("networkRuleCollections".equals(fieldName)) {
                    List networkRuleCollections;
                    deserializedAzureFirewallPropertiesFormat.networkRuleCollections = networkRuleCollections = reader.readArray(reader1 -> AzureFirewallNetworkRuleCollection.fromJson(reader1));
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedAzureFirewallPropertiesFormat.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> AzureFirewallIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("managementIpConfiguration".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.managementIpConfiguration = AzureFirewallIpConfiguration.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("threatIntelMode".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.threatIntelMode = AzureFirewallThreatIntelMode.fromString(reader.getString());
                    continue;
                }
                if ("virtualHub".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.virtualHub = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("firewallPolicy".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.firewallPolicy = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("hubIPAddresses".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.hubIpAddresses = HubIpAddresses.fromJson(reader);
                    continue;
                }
                if ("ipGroups".equals(fieldName)) {
                    List ipGroups;
                    deserializedAzureFirewallPropertiesFormat.ipGroups = ipGroups = reader.readArray(reader1 -> AzureFirewallIpGroups.fromJson(reader1));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.sku = AzureFirewallSku.fromJson(reader);
                    continue;
                }
                if ("additionalProperties".equals(fieldName)) {
                    Map additionalProperties;
                    deserializedAzureFirewallPropertiesFormat.additionalProperties = additionalProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("autoscaleConfiguration".equals(fieldName)) {
                    deserializedAzureFirewallPropertiesFormat.autoscaleConfiguration = AzureFirewallAutoscaleConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallPropertiesFormat;
        });
    }
}

