/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.WebApplicationFirewallScrubbingRules;
import com.azure.resourcemanager.network.models.WebApplicationFirewallScrubbingState;
import java.io.IOException;
import java.util.List;

public final class PolicySettingsLogScrubbing
implements JsonSerializable<PolicySettingsLogScrubbing> {
    private WebApplicationFirewallScrubbingState state;
    private List<WebApplicationFirewallScrubbingRules> scrubbingRules;

    public WebApplicationFirewallScrubbingState state() {
        return this.state;
    }

    public PolicySettingsLogScrubbing withState(WebApplicationFirewallScrubbingState state) {
        this.state = state;
        return this;
    }

    public List<WebApplicationFirewallScrubbingRules> scrubbingRules() {
        return this.scrubbingRules;
    }

    public PolicySettingsLogScrubbing withScrubbingRules(List<WebApplicationFirewallScrubbingRules> scrubbingRules) {
        this.scrubbingRules = scrubbingRules;
        return this;
    }

    public void validate() {
        if (this.scrubbingRules() != null) {
            this.scrubbingRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("scrubbingRules", this.scrubbingRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicySettingsLogScrubbing fromJson(JsonReader jsonReader) throws IOException {
        return (PolicySettingsLogScrubbing)jsonReader.readObject(reader -> {
            PolicySettingsLogScrubbing deserializedPolicySettingsLogScrubbing = new PolicySettingsLogScrubbing();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedPolicySettingsLogScrubbing.state = WebApplicationFirewallScrubbingState.fromString(reader.getString());
                    continue;
                }
                if ("scrubbingRules".equals(fieldName)) {
                    List scrubbingRules;
                    deserializedPolicySettingsLogScrubbing.scrubbingRules = scrubbingRules = reader.readArray(reader1 -> WebApplicationFirewallScrubbingRules.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicySettingsLogScrubbing;
        });
    }
}

