/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.UsageName;
import com.azure.resourcemanager.network.models.UsageUnit;
import java.io.IOException;

public final class UsageInner
implements JsonSerializable<UsageInner> {
    private String id;
    private UsageUnit unit;
    private long currentValue;
    private long limit;
    private UsageName name;
    private static final ClientLogger LOGGER = new ClientLogger(UsageInner.class);

    public String id() {
        return this.id;
    }

    public UsageUnit unit() {
        return this.unit;
    }

    public UsageInner withUnit(UsageUnit unit) {
        this.unit = unit;
        return this;
    }

    public long currentValue() {
        return this.currentValue;
    }

    public UsageInner withCurrentValue(long currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public UsageInner withLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public UsageName name() {
        return this.name;
    }

    public UsageInner withName(UsageName name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.unit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property unit in model UsageInner"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model UsageInner"));
        }
        this.name().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeLongField("currentValue", this.currentValue);
        jsonWriter.writeLongField("limit", this.limit);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        return jsonWriter.writeEndObject();
    }

    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageInner)jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("unit".equals(fieldName)) {
                    deserializedUsageInner.unit = UsageUnit.fromString(reader.getString());
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = reader.getLong();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = reader.getLong();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = UsageName.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedUsageInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageInner;
        });
    }
}

