/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectionMonitorParameters;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.azure.resourcemanager.network.models.ConnectionMonitorType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConnectionMonitorResultProperties
extends ConnectionMonitorParameters {
    private ProvisioningState provisioningState;
    private OffsetDateTime startTime;
    private String monitoringStatus;
    private ConnectionMonitorType connectionMonitorType;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public String monitoringStatus() {
        return this.monitoringStatus;
    }

    public ConnectionMonitorType connectionMonitorType() {
        return this.connectionMonitorType;
    }

    @Override
    public ConnectionMonitorResultProperties withSource(ConnectionMonitorSource source) {
        super.withSource(source);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withDestination(ConnectionMonitorDestination destination) {
        super.withDestination(destination);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withAutoStart(Boolean autoStart) {
        super.withAutoStart(autoStart);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        super.withMonitoringIntervalInSeconds(monitoringIntervalInSeconds);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        super.withEndpoints(endpoints);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        super.withTestConfigurations(testConfigurations);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        super.withTestGroups(testGroups);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withOutputs(List<ConnectionMonitorOutput> outputs) {
        super.withOutputs(outputs);
        return this;
    }

    @Override
    public ConnectionMonitorResultProperties withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    @Override
    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.testConfigurations() != null) {
            this.testConfigurations().forEach(e -> e.validate());
        }
        if (this.testGroups() != null) {
            this.testGroups().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source());
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination());
        jsonWriter.writeBooleanField("autoStart", this.autoStart());
        jsonWriter.writeNumberField("monitoringIntervalInSeconds", (Number)this.monitoringIntervalInSeconds());
        jsonWriter.writeArrayField("endpoints", this.endpoints(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("testConfigurations", this.testConfigurations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("testGroups", this.testGroups(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("notes", this.notes());
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorResultProperties)jsonReader.readObject(reader -> {
            ConnectionMonitorResultProperties deserializedConnectionMonitorResultProperties = new ConnectionMonitorResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withSource(ConnectionMonitorSource.fromJson(reader));
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withDestination(ConnectionMonitorDestination.fromJson(reader));
                    continue;
                }
                if ("autoStart".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withAutoStart((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("monitoringIntervalInSeconds".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withMonitoringIntervalInSeconds((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints = reader.readArray(reader1 -> ConnectionMonitorEndpoint.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withEndpoints(endpoints);
                    continue;
                }
                if ("testConfigurations".equals(fieldName)) {
                    List testConfigurations = reader.readArray(reader1 -> ConnectionMonitorTestConfiguration.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withTestConfigurations(testConfigurations);
                    continue;
                }
                if ("testGroups".equals(fieldName)) {
                    List testGroups = reader.readArray(reader1 -> ConnectionMonitorTestGroup.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withTestGroups(testGroups);
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs = reader.readArray(reader1 -> ConnectionMonitorOutput.fromJson(reader1));
                    deserializedConnectionMonitorResultProperties.withOutputs(outputs);
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.withNotes(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("monitoringStatus".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.monitoringStatus = reader.getString();
                    continue;
                }
                if ("connectionMonitorType".equals(fieldName)) {
                    deserializedConnectionMonitorResultProperties.connectionMonitorType = ConnectionMonitorType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorResultProperties;
        });
    }
}

