// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of VPN client root certificate of VpnServerConfiguration.
 */
@Fluent
public final class VpnServerConfigVpnClientRootCertificate
    implements JsonSerializable<VpnServerConfigVpnClientRootCertificate> {
    /*
     * The certificate name.
     */
    private String name;

    /*
     * The certificate public data.
     */
    private String publicCertData;

    /**
     * Creates an instance of VpnServerConfigVpnClientRootCertificate class.
     */
    public VpnServerConfigVpnClientRootCertificate() {
    }

    /**
     * Get the name property: The certificate name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The certificate name.
     * 
     * @param name the name value to set.
     * @return the VpnServerConfigVpnClientRootCertificate object itself.
     */
    public VpnServerConfigVpnClientRootCertificate withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publicCertData property: The certificate public data.
     * 
     * @return the publicCertData value.
     */
    public String publicCertData() {
        return this.publicCertData;
    }

    /**
     * Set the publicCertData property: The certificate public data.
     * 
     * @param publicCertData the publicCertData value to set.
     * @return the VpnServerConfigVpnClientRootCertificate object itself.
     */
    public VpnServerConfigVpnClientRootCertificate withPublicCertData(String publicCertData) {
        this.publicCertData = publicCertData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publicCertData", this.publicCertData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnServerConfigVpnClientRootCertificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnServerConfigVpnClientRootCertificate if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnServerConfigVpnClientRootCertificate.
     */
    public static VpnServerConfigVpnClientRootCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnServerConfigVpnClientRootCertificate deserializedVpnServerConfigVpnClientRootCertificate
                = new VpnServerConfigVpnClientRootCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVpnServerConfigVpnClientRootCertificate.name = reader.getString();
                } else if ("publicCertData".equals(fieldName)) {
                    deserializedVpnServerConfigVpnClientRootCertificate.publicCertData = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnServerConfigVpnClientRootCertificate;
        });
    }
}
