// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualRouterPeeringInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListVirtualRouterPeerings API service call.
 */
@Fluent
public final class VirtualRouterPeeringListResult implements JsonSerializable<VirtualRouterPeeringListResult> {
    /*
     * List of VirtualRouterPeerings in a VirtualRouter.
     */
    private List<VirtualRouterPeeringInner> value;

    /*
     * URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualRouterPeeringListResult class.
     */
    public VirtualRouterPeeringListResult() {
    }

    /**
     * Get the value property: List of VirtualRouterPeerings in a VirtualRouter.
     * 
     * @return the value value.
     */
    public List<VirtualRouterPeeringInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of VirtualRouterPeerings in a VirtualRouter.
     * 
     * @param value the value value to set.
     * @return the VirtualRouterPeeringListResult object itself.
     */
    public VirtualRouterPeeringListResult withValue(List<VirtualRouterPeeringInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualRouterPeeringListResult object itself.
     */
    public VirtualRouterPeeringListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualRouterPeeringListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualRouterPeeringListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualRouterPeeringListResult.
     */
    public static VirtualRouterPeeringListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualRouterPeeringListResult deserializedVirtualRouterPeeringListResult
                = new VirtualRouterPeeringListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualRouterPeeringInner> value
                        = reader.readArray(reader1 -> VirtualRouterPeeringInner.fromJson(reader1));
                    deserializedVirtualRouterPeeringListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualRouterPeeringListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualRouterPeeringListResult;
        });
    }
}
