// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enable or Disable apply network policies on private end point in the subnet.
 */
public final class VirtualNetworkPrivateEndpointNetworkPolicies
    extends ExpandableStringEnum<VirtualNetworkPrivateEndpointNetworkPolicies> {
    /**
     * Static value Enabled for VirtualNetworkPrivateEndpointNetworkPolicies.
     */
    public static final VirtualNetworkPrivateEndpointNetworkPolicies ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for VirtualNetworkPrivateEndpointNetworkPolicies.
     */
    public static final VirtualNetworkPrivateEndpointNetworkPolicies DISABLED = fromString("Disabled");

    /**
     * Static value NetworkSecurityGroupEnabled for VirtualNetworkPrivateEndpointNetworkPolicies.
     */
    public static final VirtualNetworkPrivateEndpointNetworkPolicies NETWORK_SECURITY_GROUP_ENABLED
        = fromString("NetworkSecurityGroupEnabled");

    /**
     * Static value RouteTableEnabled for VirtualNetworkPrivateEndpointNetworkPolicies.
     */
    public static final VirtualNetworkPrivateEndpointNetworkPolicies ROUTE_TABLE_ENABLED
        = fromString("RouteTableEnabled");

    /**
     * Creates a new instance of VirtualNetworkPrivateEndpointNetworkPolicies value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VirtualNetworkPrivateEndpointNetworkPolicies() {
    }

    /**
     * Creates or finds a VirtualNetworkPrivateEndpointNetworkPolicies from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VirtualNetworkPrivateEndpointNetworkPolicies.
     */
    public static VirtualNetworkPrivateEndpointNetworkPolicies fromString(String name) {
        return fromString(name, VirtualNetworkPrivateEndpointNetworkPolicies.class);
    }

    /**
     * Gets known VirtualNetworkPrivateEndpointNetworkPolicies values.
     * 
     * @return known VirtualNetworkPrivateEndpointNetworkPolicies values.
     */
    public static Collection<VirtualNetworkPrivateEndpointNetworkPolicies> values() {
        return values(VirtualNetworkPrivateEndpointNetworkPolicies.class);
    }
}
