// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual Network Gateway Autoscale Configuration details.
 */
@Fluent
public final class VirtualNetworkGatewayAutoScaleConfiguration
    implements JsonSerializable<VirtualNetworkGatewayAutoScaleConfiguration> {
    /*
     * The bounds of the autoscale configuration
     */
    private VirtualNetworkGatewayAutoScaleBounds bounds;

    /**
     * Creates an instance of VirtualNetworkGatewayAutoScaleConfiguration class.
     */
    public VirtualNetworkGatewayAutoScaleConfiguration() {
    }

    /**
     * Get the bounds property: The bounds of the autoscale configuration.
     * 
     * @return the bounds value.
     */
    public VirtualNetworkGatewayAutoScaleBounds bounds() {
        return this.bounds;
    }

    /**
     * Set the bounds property: The bounds of the autoscale configuration.
     * 
     * @param bounds the bounds value to set.
     * @return the VirtualNetworkGatewayAutoScaleConfiguration object itself.
     */
    public VirtualNetworkGatewayAutoScaleConfiguration withBounds(VirtualNetworkGatewayAutoScaleBounds bounds) {
        this.bounds = bounds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (bounds() != null) {
            bounds().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("bounds", this.bounds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayAutoScaleConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayAutoScaleConfiguration if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayAutoScaleConfiguration.
     */
    public static VirtualNetworkGatewayAutoScaleConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayAutoScaleConfiguration deserializedVirtualNetworkGatewayAutoScaleConfiguration
                = new VirtualNetworkGatewayAutoScaleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("bounds".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayAutoScaleConfiguration.bounds
                        = VirtualNetworkGatewayAutoScaleBounds.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayAutoScaleConfiguration;
        });
    }
}
